/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.ectoplasm;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.EctoplasmEntity;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EctoplasmExplode
extends Action {
    protected final double radius;
    protected final float damage;
    protected final float knockback;
    protected final int stun;

    public EctoplasmExplode(Action.Properties properties, double radius, float damage, float knockback, int stun, int ... duration) {
        super(properties, duration);
        this.radius = radius;
        this.damage = damage;
        this.knockback = knockback;
        this.stun = stun;
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 2.25;
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        switch (state) {
            case 0: {
                mCalc.add(0.0f, Mth.m_14089_((float)(((float)(frame - 1) + mCalc.partialTicks) * 3.0f)) * 2.0f, 0.0f);
                break;
            }
            case 1: {
                mCalc.extend(0.0f, 0.0f, 0.0f, Easing.outQuart);
            }
        }
    }

    @Override
    public void onTick(LivingEntity user) {
        IActionTracker capA;
        if (!user.f_19853_.f_46443_ && (capA = ActionTracker.get((Entity)user)).isDamaging() && capA.getFrame() == 1) {
            CombatUtil.damageAllInRadius((Entity)user, user.m_146892_(), this.radius, this.damage, this.knockback, 0.5f, DamageTypeSource.createExplosionSource(user).setImpact(this.getImpact(capA)).setStun(this.stun));
            ((ServerLevel)user.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_.m_6012_(), user.m_20185_(), user.m_20188_(), user.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            EctoplasmEntity ectoplasm = (EctoplasmEntity)user;
            ectoplasm.onKillRemoval();
            user.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

