/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.husk;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.HuskEntity;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;

public class HuskLeftSwipe
extends NPCAttack {
    public HuskLeftSwipe(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public HuskLeftSwipe(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public InteractionHand getHand() {
        return InteractionHand.OFF_HAND;
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 2;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return ActionsNF.isEmpty(this.chainsFrom().getId()) ? 1.5 : 2.0;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return HuskEntity.getLeftArmAnimMap();
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData body = data.get((Object)EntityPart.BODY);
        AnimationData leftArm = data.get((Object)EntityPart.ARM_LEFT);
        AnimationData leftHand = data.get((Object)EntityPart.HAND_LEFT);
        switch (state) {
            case 0: {
                mCalc.extend(0.0f, -60.0f, 0.0f);
                body.rCalc.extend(-15.0f, 0.0f, 0.0f);
                leftArm.rCalc.extend(pitch, 0.0f, -pitch);
                leftHand.rCalc.extend(-80.0f, -100.0f, 0.0f);
                break;
            }
            case 1: 
            case 3: {
                mCalc.freeze();
                body.rCalc.freeze();
                leftArm.rCalc.freeze();
                leftHand.rCalc.freeze();
                break;
            }
            case 2: {
                mCalc.extend(0.0f, 40.0f, 0.0f);
                mCalc.setEasing(Easing.outCubic);
                body.rCalc.extend(25.0f, 0.0f, 0.0f);
                body.rCalc.setEasing(Easing.outCubic);
                leftArm.rCalc.freeze();
                leftHand.rCalc.extend(-60.0f, 50.0f, 0.0f);
                break;
            }
            case 4: {
                mCalc.extend(0.0f, 0.0f, 0.0f);
                body.rCalc.extend(body.dRotation);
                leftArm.rCalc.extend(leftArm.dRotation);
                leftHand.rCalc.extend(leftHand.dRotation);
            }
        }
        if (data.size() != 3) {
            AnimationData head = data.get((Object)EntityPart.HEAD);
            AnimationData rightArm = data.get((Object)EntityPart.ARM_RIGHT);
            AnimationData rightHand = data.get((Object)EntityPart.HAND_RIGHT);
            switch (state) {
                case 0: {
                    head.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.extend(-30.0f, 0.0f, 15.0f);
                    break;
                }
                case 1: 
                case 3: {
                    head.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    break;
                }
                case 2: {
                    head.rCalc.add(0.0f, 50.0f, 0.0f);
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.extend(25.0f, 0.0f, 10.0f);
                    break;
                }
                case 4: {
                    head.toDefaultRotation();
                    rightHand.toDefaultRotation();
                    rightArm.toDefaultRotation();
                }
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.375f, 0.875f, -0.125f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.0f, this.hasWeapon(user) ? 0.125f : 0.0f);
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)user.m_5686_(partialTicks), (float)-45.0f, (float)25.0f);
    }

    @Override
    public String getName(LivingEntity user) {
        if (!(user.m_21206_().m_41720_() instanceof IWeaponItem)) {
            return "swipe";
        }
        return super.getName(user);
    }

    @Override
    public float getMaxXRot(int state) {
        return switch (state) {
            case 1, 3 -> 0.0f;
            case 2 -> 5.0f;
            default -> 15.0f;
        };
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 22.5f;
            case 1, 3 -> 0.0f;
            case 2 -> 14.0f;
            default -> 30.0f;
        };
    }
}

