/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.husk;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.HuskEntity;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class HuskOverhead
extends NPCAttack {
    public HuskOverhead(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public HuskOverhead(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 2;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 1.75;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return HuskEntity.getRightArmAnimMap();
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData body = data.get((Object)EntityPart.BODY);
        AnimationData rightArm = data.get((Object)EntityPart.ARM_RIGHT);
        AnimationData rightHand = data.get((Object)EntityPart.HAND_RIGHT);
        switch (state) {
            case 0: {
                body.rCalc.extend(-22.5f, 0.0f, 0.0f);
                rightArm.rCalc.extend(pitch, 0.0f, 0.0f);
                rightHand.rCalc.extend(-235.0f, 5.0f, 0.0f);
                rightHand.tCalc.add(0.0f, 1.5f, 0.0f);
                break;
            }
            case 1: {
                body.rCalc.freeze();
                rightArm.rCalc.freeze();
                rightHand.rCalc.freeze();
                rightHand.tCalc.freeze();
                break;
            }
            case 2: {
                body.rCalc.extend(40.0f, 0.0f, 0.0f);
                body.rCalc.setEasing(Easing.outCubic);
                rightArm.rCalc.freeze();
                rightHand.rCalc.extend(-45.0f, -30.0f, 0.0f);
                rightHand.rCalc.setEasing(Easing.outCubic);
                rightHand.tCalc.add(0.0f, -1.5f, 0.0f);
                rightHand.tCalc.setEasing(Easing.outCubic);
                break;
            }
            case 3: {
                body.rCalc.extend(body.dRotation);
                rightArm.rCalc.extend(rightArm.dRotation);
                rightHand.rCalc.extend(rightHand.dRotation);
                rightHand.tCalc.extend(rightHand.dTranslation);
            }
        }
        if (data.size() != 3) {
            AnimationData leftArm = data.get((Object)EntityPart.ARM_LEFT);
            AnimationData leftHand = data.get((Object)EntityPart.HAND_LEFT);
            switch (state) {
                case 0: {
                    leftArm.rCalc.extend(pitch, 0.0f, 0.0f);
                    leftHand.rCalc.extend(-235.0f, -5.0f, 0.0f);
                    leftHand.tCalc.add(0.0f, 1.5f, 0.0f);
                    break;
                }
                case 1: {
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftHand.tCalc.freeze();
                    break;
                }
                case 2: {
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.extend(-45.0f, 30.0f, 0.0f);
                    leftHand.rCalc.setEasing(Easing.outCubic);
                    leftHand.tCalc.add(0.0f, -1.5f, 0.0f);
                    leftHand.tCalc.setEasing(Easing.outCubic);
                    break;
                }
                case 3: {
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                    leftHand.tCalc.extend(leftHand.dTranslation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(-0.375f, 0.875f, -0.125f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.0f, this.hasWeapon(user) ? 0.125f : 0.0f);
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)user.m_5686_(partialTicks), (float)-45.0f, (float)30.0f);
    }

    @Override
    public String getName(LivingEntity user) {
        if (!(user.m_21205_().m_41720_() instanceof IWeaponItem)) {
            return "swipe";
        }
        return super.getName(user);
    }

    @Override
    public float getMaxXRot(int state) {
        return switch (state) {
            case 1 -> 0.0f;
            case 2 -> 4.0f;
            default -> 15.0f;
        };
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 20.0f;
            case 1 -> 0.0f;
            case 2 -> 10.0f;
            default -> 30.0f;
        };
    }
}

