/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.pit_devil;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.PitDevilEntity;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class PitDevilBite
extends NPCAttack {
    public PitDevilBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public PitDevilBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 1.75;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return PitDevilEntity.getHeadAnimMap();
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData body = data.get((Object)EntityPart.BODY);
        AnimationData neck = data.get((Object)EntityPart.NECK);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        switch (state) {
            case 0: {
                body.rCalc.add(10.0f, 0.0f, 0.0f);
                body.tCalc.add(0.0f, 1.0f, 1.0f);
                neck.rCalc.add(-10.0f, 0.0f, 0.0f);
                head.rCalc.extend(pitch, 0.0f, 0.0f);
                head.tCalc.add(0.0f, 0.0f, 1.0f);
                break;
            }
            case 1: {
                body.rCalc.add(pitch / 2.0f, 0.0f, 0.0f, Easing.outQuart);
                body.tCalc.add(0.0f, -1.0f, -1.0f, Easing.outQuart);
                neck.rCalc.add(10.0f, 0.0f, 0.0f, Easing.outQuart);
                head.rCalc.freeze();
                head.tCalc.add(0.0f, 0.0f, -2.0f, Easing.outQuart);
                break;
            }
            case 2: {
                body.toDefault();
                head.toDefault();
                neck.toDefaultRotation();
            }
        }
        if (data.size() > 3) {
            AnimationData tail = data.get((Object)EntityPart.TAIL);
            AnimationData legLeft = data.get((Object)EntityPart.LEG_LEFT);
            AnimationData legRight = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData hindLegLeft = data.get((Object)EntityPart.LEG_2_LEFT);
            AnimationData hindLegRight = data.get((Object)EntityPart.LEG_2_RIGHT);
            switch (state) {
                case 0: {
                    tail.rCalc.extend(20.0f, 0.0f, 0.0f);
                    legLeft.tCalc.add(0.0f, 0.0f, 1.5f);
                    legRight.tCalc.add(0.0f, 0.0f, 1.5f);
                    break;
                }
                case 1: {
                    tail.rCalc.extend(-5.0f, 0.0f, 0.0f, Easing.outQuart);
                    legLeft.tCalc.add(0.0f, 0.0f, -1.5f, Easing.outQuart);
                    legRight.tCalc.add(0.0f, 0.0f, -1.5f, Easing.outQuart);
                    if (!(pitch > 0.0f)) break;
                    hindLegLeft.tCalc.add(0.0f, -pitch / 25.0f, 0.0f, Easing.outQuart);
                    hindLegRight.tCalc.add(0.0f, -pitch / 25.0f, 0.0f, Easing.outQuart);
                    break;
                }
                case 2: {
                    tail.toDefaultRotation();
                    legLeft.toDefaultTranslation();
                    legRight.toDefaultTranslation();
                    hindLegLeft.toDefaultTranslation();
                    hindLegRight.toDefaultTranslation();
                }
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.0f, 0.6875f, 0.3125f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.0f, 0.28125f);
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)user.m_5686_(partialTicks), (float)-90.0f, (float)90.0f);
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && user instanceof Mob) {
            Mob mob = (Mob)user;
            IActionTracker capA = ActionTracker.get((Entity)user);
            if (capA.getState() == 0 && capA.getFrame() == capA.getDuration() - 1) {
                CombatUtil.addMovementTowardsTarget(0.75, 1.0, mob);
            }
        }
    }

    @Override
    public String getName(LivingEntity user) {
        return "bite";
    }

    @Override
    public float getMaxXRot(int state) {
        if (state == 1) {
            return 30.0f;
        }
        return super.getMaxXRot(state);
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 30.0f;
            case 1 -> 0.0f;
            default -> 45.0f;
        };
    }
}

