/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.pit_devil;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.PitDevilEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PitDevilGrowl
extends Action {
    public PitDevilGrowl(int[] duration) {
        super(duration);
    }

    public PitDevilGrowl(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void onTick(LivingEntity user) {
        IActionTracker capA = ActionTracker.get((Entity)user);
        if (capA.getState() == 1) {
            PitDevilEntity devil = (PitDevilEntity)user;
            if (!user.f_19853_.f_46443_) {
                if (capA.getFrame() % 60 == 1) {
                    user.m_5496_(this.getSound().get(), 1.5f, 0.97f + user.m_21187_().nextFloat() * 0.06f);
                }
                ++devil.growlTicks;
            }
            devil.m_5618_(devil.m_6080_());
        }
    }

    @Override
    public int getChargeTimeout() {
        return 240;
    }

    @Override
    public int getRequiredCharge(LivingEntity user) {
        return 0;
    }

    @Override
    public boolean canContinueCharging(LivingEntity user) {
        if (user.f_19853_.f_46443_) {
            return true;
        }
        PitDevilEntity devil = (PitDevilEntity)user;
        return devil.growlTicks < 240 && devil.m_5448_() != null && user.m_146892_().m_82557_(devil.m_5448_().m_146892_()) > 16.0;
    }

    @Override
    public void onChargeRelease(LivingEntity user) {
        if (!user.f_19853_.f_46443_) {
            NetworkHandler.toAllTracking((Entity)user, new GenericEntityToClient(NetworkHandler.Type.QUEUE_ACTION_TRACKER, user.m_142049_()));
            int frame = ActionTracker.get((Entity)user).getFrame() % 60;
            if (frame == 1 || frame > 18) {
                user.m_5496_(this.getSound().get(), 1.5f, 0.97f + user.m_21187_().nextFloat() * 0.06f);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData body = data.get((Object)EntityPart.BODY);
        AnimationData neck = data.get((Object)EntityPart.NECK);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        AnimationData tail = data.get((Object)EntityPart.TAIL);
        AnimationData legLeft = data.get((Object)EntityPart.LEG_LEFT);
        AnimationData legRight = data.get((Object)EntityPart.LEG_RIGHT);
        AnimationData earLeft = data.get((Object)EntityPart.EAR_LEFT);
        AnimationData earRight = data.get((Object)EntityPart.EAR_RIGHT);
        switch (state) {
            case 0: {
                body.rCalc.add(10.0f, 0.0f, 0.0f);
                body.tCalc.add(0.0f, 1.0f, 0.0f);
                head.tCalc.extend(0.0f, 1.0f, 0.0f);
                head.rCalc.extend(pitch, 0.0f, 0.0f);
                earLeft.rCalc.add(-25.0f, 0.0f, 0.0f);
                earRight.rCalc.add(-25.0f, 0.0f, 0.0f);
                tail.rCalc.extend(20.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                float f = (charge > 0.0f ? (float)(ActionTracker.get((Entity)user).getCharge() - 2) + ActionTracker.get((Entity)user).getChargePartial() : (float)(frame - 1) + head.rCalc.partialTicks) * 0.55f;
                body.rCalc.freeze();
                body.tCalc.freeze();
                head.tCalc.freeze();
                head.rCalc.freeze();
                earLeft.rCalc.freeze();
                earRight.rCalc.freeze();
                tail.rCalc.freeze();
                float scale = 0.35f;
                legLeft.rCalc.add(Mth.m_14031_((float)(f + 0.5235988f)) * 10.0f, 0.0f, 0.0f);
                legLeft.tCalc.add(0.0f, -Mth.m_14031_((float)f) * scale, Mth.m_14089_((float)f) * scale);
                legRight.rCalc.add(-Mth.m_14031_((float)(f + 0.5235988f)) * 10.0f, 0.0f, 0.0f);
                legRight.tCalc.add(0.0f, Mth.m_14031_((float)f) * scale, -Mth.m_14089_((float)f) * scale);
                break;
            }
            case 2: {
                body.toDefault();
                head.toDefaultRotation();
                neck.toDefaultRotation();
                earLeft.toDefaultRotation();
                earRight.toDefaultRotation();
                tail.toDefaultRotation();
                legLeft.toDefault();
                legRight.toDefault();
            }
        }
    }
}

