/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.rockworm;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.RockwormEntity;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class RockwormBite
extends NPCAttack {
    public RockwormBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public RockwormBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 0;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 2.7;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return RockwormEntity.getHeadAnimMap();
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData head = data.get((Object)EntityPart.HEAD);
        AnimationData lowerBody = data.get((Object)EntityPart.BODY);
        AnimationData upperBody = data.get((Object)EntityPart.BODY_2);
        switch (state) {
            case 0: {
                lowerBody.rCalc.add(35.0f + pitch * 0.5f, 0.0f, 0.0f, Easing.outCubic);
                upperBody.rCalc.add(-10.0f + pitch * 0.25f, 0.0f, 0.0f, Easing.outCubic);
                head.rCalc.add(-pitch * 0.25f, 0.0f, 0.0f, Easing.outCubic);
                head.tCalc.add(0.0f, 0.0f, -1.0f, Easing.outCubic);
                break;
            }
            case 1: {
                head.toDefault();
                lowerBody.toDefault();
                upperBody.toDefault();
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)(user.m_5686_(partialTicks) + 30.0f), (float)0.0f, (float)75.0f);
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.0f, 1.625f, 0.0f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.125f, 0.0f);
    }

    @Override
    public String getName(LivingEntity user) {
        return "bite";
    }
}

