/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.rockworm;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.npc.rockworm.RockwormRetreat;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.RockwormEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RockwormEmerge
extends Action {
    public RockwormEmerge(int[] duration) {
        super(duration);
    }

    public RockwormEmerge(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        ((RockwormRetreat)((Object)ActionsNF.ROCKWORM_RETREAT.get())).transformModelSingle(state, frame, duration, charge, pitch, user, data, mCalc);
        AnimationData head = data.get((Object)EntityPart.HEAD);
        AnimationData lowerBody = data.get((Object)EntityPart.BODY);
        AnimationData upperBody = data.get((Object)EntityPart.BODY_2);
        lowerBody.tCalc.add(0.0f, -36.0f, -3.0f, Easing.outSine);
        lowerBody.rCalc.extend(lowerBody.dRotation, Easing.outSine);
        upperBody.rCalc.extend(upperBody.dRotation, Easing.outSine);
        head.rCalc.extend(head.dRotation, Easing.outSine);
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && user instanceof RockwormEntity) {
            RockwormEntity rockworm = (RockwormEntity)user;
            IActionTracker capA = ActionTracker.get((Entity)user);
            if (!capA.isStunned()) {
                BlockPos pos;
                if (capA.getFrame() == capA.getDuration() / 2 && rockworm.canMineBlock(pos = rockworm.m_142538_().m_7494_())) {
                    rockworm.mineBlock(rockworm.f_19853_, pos);
                }
                if (capA.getFrame() == 1) {
                    rockworm.m_5496_(this.getSound().get(), 1.0f, 0.97f + rockworm.m_21187_().nextFloat() * 0.06f);
                }
            }
        }
    }
}

