/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.skeleton;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.npc.MoveSpeedAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.SkeletonEntity;
import frostnox.nightfall.entity.entity.projectile.ArrowEntity;
import frostnox.nightfall.item.IProjectileItem;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;

public class SkeletonShoot
extends MoveSpeedAction {
    public SkeletonShoot(int[] duration) {
        super(-0.5f, duration);
    }

    public SkeletonShoot(Action.Properties properties, int ... duration) {
        super(properties, -0.5f, duration);
    }

    @Override
    public void onStart(LivingEntity user) {
        if (!user.f_19853_.f_46443_) {
            user.m_5496_((SoundEvent)SoundsNF.SKELETON_BOW_PULL.get(), 1.0f, 0.975f + user.f_19853_.f_46441_.nextFloat() * 0.05f);
        }
    }

    @Override
    public void onTick(LivingEntity user) {
        super.onTick(user);
        IActionTracker capA = ActionTracker.get((Entity)user);
        Level level = user.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (capA.getState() == this.getChargeState() && !capA.isStunned()) {
                SkeletonEntity skeleton = (SkeletonEntity)user;
                LivingEntity target = skeleton.m_5448_();
                if (!user.m_21205_().m_204117_(TagsNF.BOW)) {
                    skeleton.queueAction();
                } else if (target != null && skeleton.m_21574_().m_148306_((Entity)target)) {
                    skeleton.queueAction();
                    IProjectileItem projectile = skeleton.arrowItem;
                    ArrowEntity arrow = new ArrowEntity(user.f_19853_, user, projectile);
                    arrow.m_36781_(projectile.getProjectileDamage());
                    arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    double dX = target.m_20185_() - user.m_20185_();
                    double dY = target.m_20227_(0.3) - arrow.m_20186_();
                    double dZ = target.m_20189_() - user.m_20189_();
                    double dist = Math.sqrt(dX * dX + dZ * dZ);
                    arrow.m_6686_(dX, dY + dist * 0.1, dZ, 2.5f * projectile.getProjectileVelocityScalar(), projectile.getProjectileInaccuracy());
                    level2.m_7967_((Entity)arrow);
                    skeleton.m_5496_(this.getSound().get(), 1.0f, 0.975f + user.f_19853_.f_46441_.nextFloat() * 0.05f);
                }
            }
        }
    }

    @Override
    public int getRequiredCharge(LivingEntity user) {
        return 0;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 20.0;
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData leftHand = data.get((Object)EntityPart.HAND_LEFT);
        AnimationData rightHand = data.get((Object)EntityPart.HAND_RIGHT);
        AnimationData leftArm = data.get((Object)EntityPart.ARM_LEFT);
        AnimationData rightArm = data.get((Object)EntityPart.ARM_RIGHT);
        switch (state) {
            case 0: {
                mCalc.extend(0.0f, -70.0f, 0.0f);
                rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                rightHand.rCalc.extend(-90.0f + pitch, 70.0f, 0.0f);
                leftHand.rCalc.extend(-93.0f + pitch / 4.0f, 75.0f, 0.0f);
                leftHand.tCalc.add(-1.5f, 0.0f, -0.5f);
                break;
            }
            case 1: {
                mCalc.freeze();
                rightArm.rCalc.freeze();
                leftArm.rCalc.freeze();
                rightHand.rCalc.freeze();
                leftHand.rCalc.freeze();
                leftHand.toDefaultTranslation();
                break;
            }
            case 2: {
                mCalc.freeze();
                rightArm.rCalc.freeze();
                leftArm.rCalc.freeze();
                rightHand.rCalc.freeze();
                leftHand.rCalc.freeze();
                leftHand.tCalc.freeze();
                break;
            }
            case 3: {
                mCalc.extend(0.0f, 0.0f, 0.0f);
                rightArm.toDefaultRotation();
                leftArm.toDefaultRotation();
                rightHand.toDefaultRotation();
                leftHand.toDefaultRotation();
                leftHand.tCalc.freeze();
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)user.m_5686_(partialTicks), (float)-70.0f, (float)70.0f);
    }
}

