/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.skeleton;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.SkeletonEntity;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class SkeletonThrust
extends NPCAttack {
    public SkeletonThrust(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public SkeletonThrust(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 2.5;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return SkeletonEntity.getRightArmAnimMap();
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && user instanceof Mob) {
            Mob mob = (Mob)user;
            IActionTracker capA = ActionTracker.get((Entity)user);
            if (capA.getState() == 0 && capA.getFrame() == capA.getDuration() - 2) {
                CombatUtil.addMovementTowardsTarget(0.3, 1.0, mob);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData body = data.get((Object)EntityPart.BODY);
        AnimationData rightArm = data.get((Object)EntityPart.ARM_RIGHT);
        AnimationData rightHand = data.get((Object)EntityPart.HAND_RIGHT);
        switch (state) {
            case 0: {
                body.rCalc.add(-15.0f, 0.0f, 0.0f);
                mCalc.extend(0.0f, 45.0f, 0.0f);
                rightArm.rCalc.extend(pitch, 0.0f, 0.0f);
                rightHand.rCalc.extend(30.0f, -5.0f, 0.0f);
                break;
            }
            case 1: {
                body.rCalc.add(20.0f, 0.0f, 0.0f, Easing.outCubic);
                mCalc.extend(0.0f, -30.0f, 0.0f, Easing.outCubic);
                rightArm.rCalc.freeze();
                rightHand.rCalc.extend(-75.0f, 20.0f, 0.0f, Easing.outSine);
                break;
            }
            case 2: {
                body.rCalc.freeze();
                mCalc.freeze();
                rightArm.rCalc.freeze();
                rightHand.rCalc.freeze();
                break;
            }
            case 3: {
                body.toDefaultRotation();
                mCalc.extend(0.0f, 0.0f, 0.0f);
                rightArm.rCalc.extend(rightArm.dRotation);
                rightHand.rCalc.extend(rightHand.dRotation);
            }
        }
        if (data.size() != 3) {
            AnimationData leftArm = data.get((Object)EntityPart.ARM_LEFT);
            AnimationData leftHand = data.get((Object)EntityPart.HAND_LEFT);
            switch (state) {
                case 0: {
                    leftArm.rCalc.extend(pitch / 2.0f, 0.0f, 0.0f);
                    leftHand.rCalc.extend(-25.0f, 0.0f, -10.0f);
                    break;
                }
                case 1: {
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.extend(25.0f, 0.0f, -15.0f, Easing.outCubic);
                    break;
                }
                case 2: {
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    break;
                }
                case 3: {
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.addFrom(data.dRotation, 30.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                data.rCalc.add(-90.0f, 0.0f, 0.0f, Easing.outSine);
                break;
            }
            case 2: {
                data.rCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.extend(data.dRotation);
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(-0.375f, 0.875f, 0.0f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.0f, this.hasWeapon(user) ? 0.125f : 0.0f);
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)user.m_5686_(partialTicks), (float)-45.0f, (float)45.0f);
    }

    @Override
    public String getName(LivingEntity user) {
        return super.getName(user);
    }

    @Override
    public float getMaxXRot(int state) {
        return switch (state) {
            case 1 -> 0.0f;
            case 2 -> 4.0f;
            default -> 15.0f;
        };
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 20.0f;
            case 1 -> 0.0f;
            case 2 -> 10.0f;
            default -> 30.0f;
        };
    }
}

