/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.npc.spider;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.npc.NPCAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.SpiderEntity;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class SpiderBite
extends NPCAttack {
    public SpiderBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public SpiderBite(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public double getMaxDistToStart(LivingEntity user) {
        return 2.0;
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        return SpiderEntity.getHeadAnimMap();
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        AnimationData head = data.get((Object)EntityPart.HEAD);
        switch (state) {
            case 0: {
                head.rCalc.add(-10.0f, 0.0f, 0.0f);
                head.tCalc.add(0.0f, 0.0f, 1.0f);
                break;
            }
            case 1: {
                head.rCalc.add(15.0f, 0.0f, 0.0f, Easing.outQuart);
                head.tCalc.add(0.0f, 0.0f, -1.5f, Easing.outQuart);
                break;
            }
            case 2: {
                head.toDefault();
            }
        }
        if (data.size() != 1) {
            AnimationData body = data.get((Object)EntityPart.BODY);
            AnimationData legRight = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData legLeft = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    body.tCalc.add(0.0f, 0.0f, 0.5f);
                    legRight.rCalc.extend(-75.0f, -25.0f, 0.0f, Easing.outCubic);
                    legLeft.rCalc.extend(-75.0f, 25.0f, 0.0f, Easing.outCubic);
                    break;
                }
                case 1: {
                    body.tCalc.add(0.0f, 0.0f, -1.0f, Easing.outQuart);
                    legRight.rCalc.add(75.0f, 10.0f, 0.0f, Easing.outCubic);
                    legLeft.rCalc.add(75.0f, -10.0f, 0.0f, Easing.outCubic);
                    break;
                }
                case 2: {
                    body.toDefaultTranslation();
                    legRight.toDefaultRotation();
                    legLeft.toDefaultRotation();
                }
            }
        }
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(0.0f, 0.15625f, 0.125f);
    }

    @Override
    public Vector3f getOffset(LivingEntity user) {
        return new Vector3f(0.0f, 0.0f, 0.25f);
    }

    @Override
    public void onTick(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && user instanceof Mob) {
            Mob mob = (Mob)user;
            IActionTracker capA = ActionTracker.get((Entity)user);
            if (capA.getState() == 0 && capA.getFrame() == capA.getDuration() - 1) {
                CombatUtil.addMovementTowardsTarget(0.8, 1.0, mob);
            }
        }
    }

    @Override
    public String getName(LivingEntity user) {
        return "bite";
    }

    @Override
    public float getMaxXRot(int state) {
        if (state == 1) {
            return 20.0f;
        }
        return super.getMaxXRot(state);
    }

    @Override
    public float getMaxYRot(int state) {
        return switch (state) {
            case 0 -> 45.0f;
            case 1 -> 0.0f;
            default -> 60.0f;
        };
    }
}

