/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public interface IClientAction {
    public Action getAction();

    default public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        Action last;
        if (!ActionsNF.isEmpty(this.getAction().chainsFrom().getId()) && (last = (Action)((Object)this.getAction().chainsFrom().get())) instanceof IClientAction) {
            ((IClientAction)((Object)last)).transformModelFP(last.getChainState(), 2, 2, charge, user, data);
        }
        if (state != 0) {
            this.transformModelFP(state - 1, 2, 2, charge, user, data);
        }
        data.rCalc.resetLength(duration, Easing.inOutSine);
        data.tCalc.resetLength(duration, Easing.inOutSine);
        data.sCalc.resetLength(duration, Easing.inOutSine);
    }

    default public void transformOppositeModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        Action last;
        if (!ActionsNF.isEmpty(this.getAction().chainsFrom().getId()) && (last = (Action)((Object)this.getAction().chainsFrom().get())) instanceof IClientAction) {
            ((IClientAction)((Object)last)).transformOppositeModelFP(last.getChainState(), 2, 2, charge, user, data);
        }
        if (state != 0) {
            this.transformOppositeModelFP(state - 1, 2, 2, charge, user, data);
        }
        data.rCalc.resetLength(duration, Easing.inOutSine);
        data.tCalc.resetLength(duration, Easing.inOutSine);
        data.sCalc.resetLength(duration, Easing.inOutSine);
    }

    default public void transformOppositeLayer(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        Action last;
        if (state == 0 && !ActionsNF.isEmpty(this.getAction().chainsFrom().getId()) && (last = (Action)((Object)this.getAction().chainsFrom().get())) instanceof IClientAction) {
            ((IClientAction)((Object)last)).transformOppositeLayer(last.getChainState(), 2, 2, charge, user, data);
        }
        if (state != 0) {
            this.transformOppositeLayer(state - 1, 2, 2, charge, user, data);
        }
        data.resetLengths(duration, Easing.inOutSine);
        this.transformOppositeLayerSingle(state, frame, duration, charge, user, data);
    }

    default public void transformOppositeLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
    }

    default public void transformOppositeHandFP(AnimationCalculator tCalc, int xSide, int side, IActionTracker capA) {
        if (this.getAction().getTotalStates() > 1) {
            if (capA.getState() == 0 && ActionsNF.isEmpty(this.getAction().chainsFrom().getId()) || capA.getState() == this.getAction().getTotalStates() - 1) {
                tCalc.add(0.95f * (float)xSide * (float)side, -0.95f * (float)side, 0.0f);
                if (capA.getState() == this.getAction().getTotalStates() - 1) {
                    tCalc.add(-0.95f * (float)xSide * (float)side, 0.95f * (float)side, 0.0f);
                }
            } else {
                tCalc.setStaticVector(0.95f * (float)xSide * (float)side, -0.95f * (float)side, 0.0f);
            }
        }
    }

    default public void onClientTick(Player player) {
    }
}

