/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.util.RenderUtil;
import frostnox.nightfall.util.animation.AnimationData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class PlayerAttack
extends Attack
implements IClientAction {
    public PlayerAttack(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public PlayerAttack(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public boolean canStart(LivingEntity user) {
        if (super.canStart(user)) {
            return PlayerData.get((Player)user).hasNoSwapDelay();
        }
        return false;
    }

    @Override
    public Action getAction() {
        return this;
    }

    @Override
    public float getDamage(LivingEntity user) {
        Player player;
        Item item;
        if (user instanceof Player && (item = user.m_21120_(PlayerData.get(player = (Player)user).getActiveHand()).m_41720_()) instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item;
            return (super.getDamage(user) * weapon.getDamageMultiplier() + weapon.getBaseDamage()) * AttributesNF.getStrengthMultiplier(user);
        }
        return super.getDamage(user);
    }

    @Override
    public HurtSphere getHurtSpheres(LivingEntity user) {
        Player player;
        Item item;
        if (user instanceof Player && (item = (player = (Player)user).m_21120_(PlayerData.get(player).getActiveHand()).m_41720_()) instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item;
            return weapon.getHurtSpheres();
        }
        return super.getHurtSpheres(user);
    }

    @Override
    public Vector3f getTranslation(LivingEntity user) {
        return new Vector3f(-0.56f, -0.52f, 0.5f);
    }

    @Override
    protected EnumMap<EntityPart, AnimationData> getDefaultAnimationData() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.HAND_RIGHT, new AnimationData());
        return map;
    }

    @Override
    public float getMaxXRot(int state) {
        if (state == this.getTotalStates() - 1) {
            return 22.5f;
        }
        if (state == 0) {
            return 12.5f;
        }
        return 8.0f;
    }

    @Override
    public float getMaxYRot(int state) {
        if (state == this.getTotalStates() - 1) {
            return 45.0f;
        }
        if (state == 0) {
            return 25.0f;
        }
        return 17.5f;
    }

    @Override
    public List<Component> getTooltips(ItemStack stack, @Nullable Level level, TooltipFlag isAdvanced) {
        int i;
        float itemDamage;
        DecimalFormat format = new DecimalFormat("0.0");
        Item item = stack.m_41720_();
        if (item instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item;
            itemDamage = this.damage * weapon.getDamageMultiplier() + weapon.getBaseDamage();
        } else {
            itemDamage = this.damage;
        }
        TextComponent text = new TextComponent(format.format(itemDamage) + " ");
        text.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        for (i = 0; i < this.damageType.length; ++i) {
            text.m_7220_((Component)RenderUtil.getDamageTypeText(this.damageType[i]));
            if (i == this.damageType.length - 1) continue;
            text.m_130946_("/");
        }
        for (i = 0; i < this.effects.length; ++i) {
            text.m_130946_(", " + (int)(this.effects[i].chance * 100.0f) + "% ");
            text.m_7220_(this.effects[i].effect.get().m_19482_());
        }
        return ObjectArrayList.of((Object[])new Component[]{text});
    }
}

