/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.WoodCarveAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class AxeCarveAction
extends WoodCarveAction {
    public AxeCarveAction(int[] duration, Action.Properties properties) {
        super(properties, duration);
    }

    public AxeCarveAction(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                tCalc.add(-0.8125f, 0.625f, -0.625f);
                rCalc.extend(-10.0f, 245.0f, -90.0f);
                break;
            }
            case 1: {
                data.tCalc.addWithCharge(0.0625f, -0.3125f, 0.0f, Math.min(1.0f, (float)ActionTracker.get((Entity)user).getCharge() % 10.0f / 3.0f), Easing.outSine);
                if (charge == 0.0f) {
                    data.tCalc.frame %= 10;
                }
                if ((charge > 0.0f ? ActionTracker.get((Entity)user).getCharge() : frame) % 10 > 3) {
                    if (charge == 0.0f) {
                        data.tCalc.frame -= 3;
                    }
                    data.tCalc.addWithCharge(-0.0625f, 0.3125f, 0.0f, Math.min(1.0f, ((float)ActionTracker.get((Entity)user).getCharge() % 10.0f - 3.0f) / 4.0f));
                    data.tCalc.length = 4;
                } else {
                    data.tCalc.length = 3;
                }
                rCalc.freeze();
                break;
            }
            case 2: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            switch (state) {
                case 0: {
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.rCalc.add(-60.0f, -40.0f, 0.0f);
                    leftHand.rCalc.add(-35.0f, 20.0f, 0.0f);
                    break;
                }
                case 1: {
                    rightArm.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    rightHand.rCalc.addWithCharge(30.0f, 0.0f, 0.0f, Math.min(1.0f, (float)ActionTracker.get((Entity)user).getCharge() % 10.0f / 3.0f), Easing.outSine);
                    if (charge == 0.0f) {
                        rightHand.rCalc.frame %= 10;
                    }
                    if ((charge > 0.0f ? ActionTracker.get((Entity)user).getCharge() : frame) % 10 > 3) {
                        if (charge == 0.0f) {
                            rightHand.rCalc.frame -= 3;
                        }
                        rightHand.rCalc.addWithCharge(-30.0f, 0.0f, 0.0f, Math.min(1.0f, ((float)ActionTracker.get((Entity)user).getCharge() % 10.0f - 3.0f) / 4.0f));
                        rightHand.rCalc.length = 4;
                    } else {
                        rightHand.rCalc.length = 3;
                    }
                    leftHand.rCalc.freeze();
                    break;
                }
                case 2: {
                    rightArm.toDefaultRotation();
                    leftArm.toDefaultRotation();
                    rightHand.toDefaultRotation();
                    leftHand.toDefaultRotation();
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.tCalc.add(0.0f, -0.3125f, 0.0f);
                data.rCalc.add(-10.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                data.tCalc.freeze();
                data.rCalc.freeze();
                break;
            }
            case 2: {
                data.toDefault();
            }
        }
    }
}

