/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.LaunchProjectileAction;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BowShoot
extends LaunchProjectileAction {
    public BowShoot(Action.Properties properties, float speedMultiplier, float velocity, int ... duration) {
        super(properties, speedMultiplier, velocity, duration);
    }

    @Override
    public void onStart(LivingEntity user) {
        if (!user.f_19853_.f_46443_) {
            user.f_19853_.m_6269_(null, (Entity)user, (SoundEvent)SoundsNF.BOW_PULL.get(), SoundSource.PLAYERS, 1.0f, 0.975f + user.f_19853_.f_46441_.nextFloat() * 0.05f);
        }
    }

    @Override
    public boolean allowDodging(int state) {
        return state > this.getChargeState();
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        switch (state) {
            case 0: {
                data.rCalc.add(-10.0f, 0.0f, 0.0f);
                data.tCalc.add(-0.25f, 0.1875f, 0.125f);
                break;
            }
            case 1: {
                data.rCalc.freeze();
                data.tCalc.add(0.0f, charge > 0.0f ? 0.0f : Mth.m_14031_((float)(((float)(frame - 1) + data.tCalc.partialTicks) * 1.2f)) * 0.005f, 0.0f);
                data.sCalc.add(0.3f, 0.0f, 0.0f, Easing.outCubic);
                break;
            }
            case 2: {
                data.rCalc.freeze();
                data.tCalc.add(0.0f, 0.0f, -0.125f, Easing.outQuart);
                data.sCalc.extend(data.dScale, Easing.outCubic);
                break;
            }
            case 3: {
                data.toDefault();
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        if (data.size() == 6) {
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            switch (state) {
                case 0: {
                    mCalc.extend(0.0f, -70.0f, 0.0f);
                    rightHand.rCalc.extend(-90.0f + pitch, 70.0f, 0.0f);
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    leftArm.rCalc.extend(pitch / 4.0f, 0.0f, 0.0f);
                    leftHand.rCalc.extend(-93.0f + pitch / 4.0f, 75.0f, 0.0f);
                    leftHand.tCalc.add(-1.5f, 0.0f, -0.5f);
                    break;
                }
                case 1: {
                    mCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftHand.tCalc.addWithCharge(1.5f, 0.0f, 0.0f, charge, Easing.outSine);
                    break;
                }
                case 2: {
                    mCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftHand.tCalc.freeze();
                    break;
                }
                case 3: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.toDefaultRotation();
                    rightArm.toDefaultRotation();
                    leftArm.toDefaultRotation();
                    leftHand.toDefault();
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.add(0.0f, 10.0f, 0.0f);
                break;
            }
            case 1: {
                data.rCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.freeze();
                break;
            }
            case 3: {
                data.toDefaultRotation();
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partialTicks) {
        return Mth.m_14036_((float)user.m_5686_(partialTicks), (float)-80.0f, (float)70.0f);
    }
}

