/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.MoveSpeedPlayerAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.data.recipe.HeldToolRecipe;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class CarveAction
extends MoveSpeedPlayerAction {
    public CarveAction(int[] duration, Action.Properties properties) {
        super(properties, -0.25f, duration);
    }

    public CarveAction(Action.Properties properties, int ... duration) {
        super(properties, -0.25f, duration);
    }

    @Override
    public int getRequiredCharge(LivingEntity user) {
        return 0;
    }

    @Override
    public int getChargeTimeout() {
        return 32768;
    }

    @Override
    public boolean hasChargeZoom() {
        return false;
    }

    @Override
    public void onTick(LivingEntity user) {
        super.onTick(user);
        IActionTracker capA = ActionTracker.get((Entity)user);
        if (!user.f_19853_.f_46443_ && capA.getFrame() % this.getDuration(this.getChargeState(), user) == 0) {
            Player player = (Player)user;
            Optional<HeldToolRecipe> recipe = HeldToolRecipe.getRecipe(player);
            if (recipe.isPresent()) {
                ItemStack oppItem = user.m_21120_(PlayerData.get(player).getOppositeActiveHand());
                if (!player.m_150110_().f_35937_) {
                    oppItem.m_41774_(1);
                }
                LevelUtil.giveItemToPlayer(recipe.get().m_8043_(), player, true);
                if (oppItem.m_41619_()) {
                    capA.queue();
                    NetworkHandler.toAllTrackingAndSelf((Entity)player, new GenericEntityToClient(NetworkHandler.Type.QUEUE_ACTION_TRACKER, player.m_142049_()));
                }
            } else {
                capA.queue();
                NetworkHandler.toAllTrackingAndSelf((Entity)player, new GenericEntityToClient(NetworkHandler.Type.QUEUE_ACTION_TRACKER, player.m_142049_()));
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return 0.0f;
    }

    @Override
    public void transformOppositeHandFP(AnimationCalculator tCalc, int xSide, int side, IActionTracker capA) {
        tCalc.add(-0.1875f * (float)xSide * (float)side, 0.0f, -0.1875f * (float)side);
        if (capA.getState() >= 1) {
            tCalc.freeze();
        }
        if (capA.getState() >= 2) {
            tCalc.extend(Vector3f.f_176763_);
        }
    }
}

