/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.MoveSpeedPlayerAction;
import frostnox.nightfall.block.block.anvil.AnvilAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.world.GridUseToServer;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ChiselAndHammerAlternate
extends MoveSpeedPlayerAction {
    public ChiselAndHammerAlternate(int[] duration, Action.Properties properties) {
        super(properties, -0.25f, duration);
    }

    public ChiselAndHammerAlternate(Action.Properties properties, int ... duration) {
        super(properties, -0.25f, duration);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                tCalc.extend(-0.6875f, 0.53125f, -0.4375f);
                rCalc.extend(0.0f, 83.0f, -90.0f);
                break;
            }
            case 1: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 2: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 3: {
                boolean hitstop = PlayerData.get((Player)user).getHitStopFrame() != -1;
                tCalc.add(hitstop ? 0.015625f : 0.0625f, 0.0f, hitstop ? -0.125f : -0.5f, Easing.outQuart);
                rCalc.addWithHitStop(user, this.getDuration(2, user), 0.0f, -1.0f, 0.0f, Easing.outQuart);
                break;
            }
            case 4: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 5: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    public void transformOppositeModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformOppositeModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                tCalc.extend(-0.25f, 0.0f, 0.1875f);
                rCalc.extend(dRotation.m_122239_() + 30.0f, dRotation.m_122260_(), dRotation.m_122269_());
                break;
            }
            case 1: {
                tCalc.addWithCharge(0.0f, 0.0f, 0.1875f, charge);
                rCalc.addWithCharge(3.0f, 0.0f, 0.0f, charge);
                break;
            }
            case 2: {
                tCalc.extend(-0.4375f, -0.0625f, 0.0f);
                rCalc.add(-35.0f, 13.0f, 0.0f);
                break;
            }
            case 3: {
                tCalc.add(0.0f, 0.0f, 0.0625f, Easing.outQuart);
                rCalc.add(3.0f, 0.0f, 0.0f, Easing.outQuart);
                break;
            }
            case 4: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 5: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
                tCalc.length -= 2;
                rCalc.length -= 2;
            }
        }
    }

    @Override
    public void transformOppositeHandFP(AnimationCalculator tCalc, int xSide, int side, IActionTracker capA) {
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            AnimationData rightLeg = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData leftLeg = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.rCalc.extend(-110.0f + pitch, -25.0f, 0.0f - pitch / 4.0f);
                    rightHand.toDefaultTranslation();
                    leftArm.rCalc.extend(pitch, 0.0f, pitch / 4.0f);
                    leftHand.rCalc.extend(-120.0f, 20.0f, 0.0f);
                    leftHand.tCalc.addFrom(leftHand.dTranslation, 0.0f, 0.0f, 1.0f);
                    break;
                }
                case 1: {
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightHand.tCalc.freeze();
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.addWithCharge(-15.0f, 0.0f, 0.0f, charge);
                    leftHand.tCalc.freeze();
                    break;
                }
                case 2: {
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightHand.tCalc.freeze();
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.extend(-75.0f, 20.0f, 0.0f, Easing.outCubic);
                    leftHand.tCalc.freeze();
                    break;
                }
                case 3: {
                    rightArm.rCalc.freeze();
                    boolean hitstop = PlayerData.get((Player)user).getHitStopFrame() != -1;
                    rightHand.rCalc.add(hitstop ? 4.0f : 10.0f, 0.0f, 0.0f, Easing.outQuart);
                    rightHand.tCalc.addFrom(leftHand.dTranslation, 0.0f, 0.0f, -0.5f);
                    rightHand.tCalc.setEasing(Easing.outQuart);
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.add(-3.0f, 0.0f, 0.0f, Easing.outQuart);
                    leftHand.tCalc.freeze();
                    break;
                }
                case 4: {
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightHand.tCalc.freeze();
                    leftHand.tCalc.freeze();
                    break;
                }
                case 5: {
                    rightArm.toDefaultRotation();
                    leftArm.toDefaultRotation();
                    rightHand.toDefault();
                    leftHand.toDefault();
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.extend(-15.0f, 65.0f, -90.0f);
                data.tCalc.addFrom(data.dTranslation, -0.09375f, 0.03125f, -0.15625f);
                break;
            }
            case 1: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 4: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 5: {
                data.toDefault();
            }
        }
    }

    @Override
    public void transformOppositeLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.addFrom(data.dRotation, 10.0f, 5.0f, 0.0f);
                data.tCalc.addFrom(data.dTranslation, 0.0f, -0.25f, 0.0f);
                data.tCalc.setEasing(Easing.outSine);
                break;
            }
            case 1: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.add(-10.0f, 0.0f, 0.0f, Easing.outCubic);
                data.tCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.add(5.0f, 0.0f, 0.0f, Easing.outQuart);
                data.tCalc.freeze();
                break;
            }
            case 4: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 5: {
                data.toDefault();
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)user.m_5686_(partial), (float)-65.0f, (float)60.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 3;
    }

    @Override
    public int getBlockHitFrame(int state, LivingEntity user) {
        return 1;
    }

    @Override
    public void onClientTick(Player player) {
        if (!player.f_19853_.m_5776_()) {
            return;
        }
        Vec3i lookingAt = ClientEngine.get().microHitResult;
        BlockPos pos = ClientEngine.get().microBlockEntityPos;
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (this.isStateDamaging(capA.getState()) && !capA.isStunned() && capA.getFrame() == this.getBlockHitFrame(capA.getState(), (LivingEntity)player) && lookingAt != null && pos != null) {
            AnvilAction type = capA.getCharge() > capA.getAction().getMaxCharge() / 2 ? AnvilAction.PUNCH_SQUARE : AnvilAction.PUNCH_LINE;
            NetworkHandler.toServer(new GridUseToServer(type.ordinal(), lookingAt, pos));
            PlayerData.get(player).setHitStopFrame(capA.getFrame());
        }
    }

    @Override
    public List<Component> getTooltips(ItemStack stack, @Nullable Level level, TooltipFlag isAdvanced) {
        List<Component> tooltips = super.getTooltips(stack, level, isAdvanced);
        if (ClientEngine.get().isShiftHeld() && ClientEngine.get().getPlayer() != null && PlayerData.get(ClientEngine.get().getPlayer()).hasCompletedEntry(EntriesNF.SMITHING.getId())) {
            tooltips.add((Component)new TextComponent(""));
            tooltips.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("anvil.action.context").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TranslatableComponent("anvil.action." + AnvilAction.PUNCH_LINE.name().toLowerCase() + ".info").m_130940_(ChatFormatting.DARK_AQUA)));
            tooltips.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("anvil.action.context_charged").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TranslatableComponent("anvil.action." + AnvilAction.PUNCH_SQUARE.name().toLowerCase() + ".info").m_130940_(ChatFormatting.DARK_AQUA)));
        }
        return tooltips;
    }
}

