/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.PlayerAction;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ChiselAndHammerCrawling
extends PlayerAction {
    public ChiselAndHammerCrawling(int[] duration, Action.Properties properties) {
        super(properties, duration);
    }

    public ChiselAndHammerCrawling(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                tCalc.extend(-0.6875f, 0.53125f, -0.4375f);
                rCalc.extend(0.0f, 83.0f, -90.0f);
                break;
            }
            case 1: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 2: {
                boolean hitstop = PlayerData.get((Player)user).getHitStopFrame() != -1;
                tCalc.add(hitstop ? 0.015625f : 0.0625f, 0.0f, hitstop ? -0.125f : -0.5f, Easing.outQuart);
                rCalc.addWithHitStop(user, this.getDuration(2, user), 0.0f, -1.0f, 0.0f, Easing.outQuart);
                break;
            }
            case 3: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 4: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    public void transformOppositeModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformOppositeModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                tCalc.extend(-0.25f, 0.0f, 0.1875f);
                rCalc.extend(dRotation.m_122239_() + 30.0f, dRotation.m_122260_(), dRotation.m_122269_());
                break;
            }
            case 1: {
                tCalc.extend(-0.4375f, -0.0625f, 0.0f);
                rCalc.add(-35.0f, 13.0f, 0.0f);
                break;
            }
            case 2: {
                tCalc.add(0.0f, 0.0f, 0.0625f, Easing.outQuart);
                rCalc.add(3.0f, 0.0f, 0.0f, Easing.outQuart);
                break;
            }
            case 3: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 4: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
                tCalc.length -= 2;
                rCalc.length -= 2;
            }
        }
    }

    @Override
    public void transformOppositeHandFP(AnimationCalculator tCalc, int xSide, int side, IActionTracker capA) {
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            AnimationData rightLeg = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData leftLeg = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.rCalc.extend(-165.0f + pitch, -5.0f, 20.0f - pitch / 4.0f);
                    rightHand.toDefaultTranslation();
                    leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    leftHand.rCalc.extend(-175.0f + pitch, 10.0f, -20.0f + pitch / 4.0f);
                    leftHand.tCalc.addFrom(leftHand.dTranslation, 0.0f, 0.0f, 1.0f);
                    break;
                }
                case 1: {
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightHand.tCalc.freeze();
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.add(45.0f, 0.0f, 0.0f, Easing.outCubic);
                    leftHand.tCalc.freeze();
                    break;
                }
                case 2: {
                    rightArm.rCalc.freeze();
                    boolean hitstop = PlayerData.get((Player)user).getHitStopFrame() != -1;
                    rightHand.rCalc.add(hitstop ? 4.0f : 10.0f, 0.0f, 0.0f, Easing.outQuart);
                    rightHand.tCalc.addFrom(leftHand.dTranslation, 0.0f, 0.0f, -0.5f);
                    rightHand.tCalc.setEasing(Easing.outQuart);
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.add(-3.0f, 0.0f, 0.0f, Easing.outQuart);
                    leftHand.tCalc.freeze();
                    break;
                }
                case 3: {
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightHand.tCalc.freeze();
                    leftHand.tCalc.freeze();
                    break;
                }
                case 4: {
                    rightArm.toDefaultRotation();
                    leftArm.toDefaultRotation();
                    rightHand.toDefault();
                    leftHand.toDefault();
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.extend(-5.0f, 80.0f, -90.0f);
                data.tCalc.addFrom(data.dTranslation, -0.09375f, 0.03125f, -0.15625f);
                break;
            }
            case 1: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 4: {
                data.toDefault();
            }
        }
    }

    @Override
    public void transformOppositeLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.addFrom(data.dRotation, 10.0f, 10.0f, 0.0f);
                data.tCalc.addFrom(data.dTranslation, 0.0f, -0.25f, 0.0f);
                data.tCalc.setEasing(Easing.outSine);
                break;
            }
            case 1: {
                data.rCalc.add(-10.0f, 0.0f, 0.0f, Easing.outCubic);
                data.tCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.add(5.0f, 0.0f, 0.0f, Easing.outQuart);
                data.tCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 4: {
                data.toDefault();
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)user.m_5686_(partial), (float)-55.0f, (float)50.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 2;
    }

    @Override
    public int getBlockHitFrame(int state, LivingEntity user) {
        return 1;
    }
}

