/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.CarveAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ChiselCarveAction
extends CarveAction {
    public ChiselCarveAction(int[] duration, Action.Properties properties) {
        super(properties, duration);
    }

    public ChiselCarveAction(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void onTick(LivingEntity user) {
        super.onTick(user);
        IActionTracker capA = ActionTracker.get((Entity)user);
        if (capA.getState() == this.getChargeState() && capA.getFrame() % 10 == 7) {
            Player player;
            ItemStack oppItem = user.m_21120_(PlayerData.get(player = (Player)user).getOppositeActiveHand());
            player.m_5496_(oppItem.m_204117_(TagsNF.ROCK) ? (SoundEvent)SoundsNF.CARVE_STONE.get() : (SoundEvent)SoundsNF.CARVE_WOOD.get(), 0.6f, 0.97f + player.m_21187_().nextFloat() * 0.06f);
        }
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                tCalc.add(-0.546875f, 0.375f, -0.0625f);
                rCalc.extend(0.0f, 0.0f, 100.0f);
                break;
            }
            case 1: {
                data.tCalc.addWithCharge(0.375f, 0.0625f, 0.0f, Math.min(1.0f, (float)ActionTracker.get((Entity)user).getCharge() % 10.0f / 3.0f), Easing.outSine);
                if (charge == 0.0f) {
                    data.tCalc.frame %= 10;
                }
                if ((charge > 0.0f ? ActionTracker.get((Entity)user).getCharge() : frame) % 10 > 3) {
                    if (charge == 0.0f) {
                        data.tCalc.frame -= 3;
                    }
                    data.tCalc.addWithCharge(-0.375f, -0.0625f, 0.0f, Math.min(1.0f, ((float)ActionTracker.get((Entity)user).getCharge() % 10.0f - 3.0f) / 4.0f), Easing.outCubic);
                    data.tCalc.length = 4;
                } else {
                    data.tCalc.length = 3;
                }
                rCalc.freeze();
                break;
            }
            case 2: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            switch (state) {
                case 0: {
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.rCalc.add(-100.0f, -40.0f, 0.0f);
                    leftHand.rCalc.add(-35.0f, 25.0f, 0.0f);
                    break;
                }
                case 1: {
                    rightArm.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    rightHand.rCalc.addWithCharge(-30.0f, 0.0f, 0.0f, Math.min(1.0f, (float)ActionTracker.get((Entity)user).getCharge() % 10.0f / 3.0f), Easing.outSine);
                    if (charge == 0.0f) {
                        rightHand.rCalc.frame %= 10;
                    }
                    if ((charge > 0.0f ? ActionTracker.get((Entity)user).getCharge() : frame) % 10 > 3) {
                        if (charge == 0.0f) {
                            rightHand.rCalc.frame -= 3;
                        }
                        rightHand.rCalc.addWithCharge(30.0f, 0.0f, 0.0f, Math.min(1.0f, ((float)ActionTracker.get((Entity)user).getCharge() % 10.0f - 3.0f) / 4.0f), Easing.outCubic);
                        rightHand.rCalc.length = 4;
                    } else {
                        rightHand.rCalc.length = 3;
                    }
                    leftHand.rCalc.freeze();
                    break;
                }
                case 2: {
                    rightArm.toDefaultRotation();
                    leftArm.toDefaultRotation();
                    rightHand.toDefaultRotation();
                    leftHand.toDefaultRotation();
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.tCalc.add(0.0f, 0.125f, 0.0f);
                data.rCalc.add(-160.0f, 15.0f, 0.0f);
                break;
            }
            case 1: {
                data.tCalc.freeze();
                data.rCalc.freeze();
                break;
            }
            case 2: {
                data.toDefault();
            }
        }
    }
}

