/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.PlayerAction;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CrawlingDig
extends PlayerAction {
    public CrawlingDig(int[] duration, Action.Properties properties) {
        super(properties, duration);
    }

    public CrawlingDig(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        AnimationCalculator sCalc = data.sCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        Vector3f dScale = data.dScale;
        switch (state) {
            case 0: {
                tCalc.extend(0.21875f, 0.140625f, 0.75f);
                rCalc.extend(-120.0f, 80.0f, 20.0f);
                break;
            }
            case 1: {
                tCalc.extend(-0.34375f, 0.375f, -0.5f, Easing.outSine);
                rCalc.extend(-120.0f, 80.0f, 20.0f, Easing.outSine);
                break;
            }
            case 2: {
                tCalc.extend(-0.0625f, 0.375f, -0.125f, Easing.inSine);
                rCalc.extend(-25.0f, 110.0f, 0.0f, Easing.outSine);
                break;
            }
            case 3: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 4: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        if (data.size() == 6) {
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            AnimationData rightLeg = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData leftLeg = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    mCalc.setVectors(0.0f, 0.0f, 0.0f, -1.0f, 2.0f, 0.0f);
                    rightHand.rCalc.add(0.0f, 20.0f, 90.0f);
                    rightArm.rCalc.extend(-180.0f + pitch, 0.0f, 0.0f);
                    break;
                }
                case 1: {
                    mCalc.extend(0.0f, -2.0f, 0.0f, Easing.outCubic);
                    rightHand.rCalc.add(0.0f, -20.0f, -95.0f, Easing.outCubic);
                    rightArm.rCalc.freeze();
                    break;
                }
                case 2: {
                    mCalc.freeze();
                    rightHand.rCalc.add(-30.0f, 0.0f, 0.0f, Easing.outCubic);
                    rightArm.rCalc.freeze();
                    break;
                }
                case 3: {
                    mCalc.freeze();
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    break;
                }
                case 4: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.toDefaultRotation();
                    rightArm.toDefaultRotation();
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        switch (state) {
            case 0: {
                data.rCalc.extend(data.dRotation.m_122239_(), data.dRotation.m_122260_() + 90.0f, data.dRotation.m_122269_() - 90.0f);
                break;
            }
            case 1: {
                data.rCalc.add(0.0f, -90.0f, 0.0f, Easing.outQuart);
                break;
            }
            case 2: {
                data.rCalc.extend(data.dRotation, Easing.outCubic);
                break;
            }
            case 3: {
                data.rCalc.freeze();
                break;
            }
            case 4: {
                data.toDefaultRotation();
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)(user.m_5686_(partial) - 14.0f), (float)-70.0f, (float)70.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public int getBlockHitFrame(int state, LivingEntity user) {
        return this.getDuration(1, user);
    }
}

