/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.PlayerAction;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DigCharged
extends PlayerAction {
    public DigCharged(int[] duration, Action.Properties properties) {
        super(properties, duration);
    }

    public DigCharged(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        AnimationCalculator sCalc = data.sCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        Vector3f dScale = data.dScale;
        switch (state) {
            case 0: {
                tCalc.extendWithCharge(0.21875f, 0.140625f, 0.875f, charge, Easing.outSine);
                rCalc.length /= 2;
                rCalc.extend(-120.0f, 80.0f, 20.0f);
                break;
            }
            case 1: {
                tCalc.extend(-0.34375f, 0.375f, -0.5f, Easing.outSine);
                rCalc.extend(-120.0f, 80.0f, 20.0f, Easing.outSine);
                break;
            }
            case 2: {
                tCalc.extend(-0.0625f, 0.375f, -0.125f, Easing.inSine);
                rCalc.extend(-25.0f, 110.0f, 0.0f, Easing.outSine);
                break;
            }
            case 3: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 4: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            AnimationData rightLeg = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData leftLeg = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    mCalc.extendWithCharge(0.0f, 30.0f, 0.0f, charge, Easing.outSine);
                    rightArm.rCalc.extendWithCharge(0.0f, 0.0f, 0.0f, charge, Easing.outQuart);
                    rightHand.rCalc.extendWithCharge(30.0f + pitch / 2.0f, 0.0f, 10.0f, charge, Easing.outQuart);
                    leftArm.rCalc.extendWithCharge(-Math.abs(pitch / 2.0f), 0.0f, 0.0f, charge, Easing.outQuart);
                    leftHand.rCalc.extendWithCharge(-20.0f, 0.0f, -10.0f, charge, Easing.outQuart);
                    break;
                }
                case 1: {
                    mCalc.extend(0.0f, -25.0f, 0.0f, Easing.outCubic);
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.extend(-45.0f + pitch, 8.0f, -pitch / 8.0f, Easing.outCubic);
                    leftHand.rCalc.extend(15.0f, 0.0f, -15.0f);
                    leftArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    break;
                }
                case 2: {
                    mCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    rightHand.rCalc.extend(-85.0f + pitch, 8.0f, -pitch / 8.0f, Easing.outCubic);
                    break;
                }
                case 3: {
                    mCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    break;
                }
                case 4: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    mCalc.setEasing(Easing.inOutSine);
                    rightArm.rCalc.extend(rightArm.dRotation);
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                    rightHand.rCalc.extend(rightHand.dRotation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        switch (state) {
            case 0: {
                data.rCalc.freeze();
                break;
            }
            case 1: {
                data.rCalc.add(-45.0f, 0.0f, 0.0f, Easing.outCubic);
                break;
            }
            case 2: {
                data.rCalc.extend(data.dRotation, Easing.outCubic);
                break;
            }
            case 3: {
                data.rCalc.freeze();
                break;
            }
            case 4: {
                data.rCalc.extend(data.dRotation);
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)(user.m_5686_(partial) - (float)(user.m_6047_() ? 11 : 14)), (float)-80.0f, (float)75.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public int getBlockHitFrame(int state, LivingEntity user) {
        return this.getDuration(1, user);
    }
}

