/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.PlayerAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.util.CombatUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public abstract class MoveSpeedPlayerAction
extends PlayerAction {
    public final float speedMultiplier;

    public MoveSpeedPlayerAction(float speedMultiplier, int ... duration) {
        super(duration);
        this.speedMultiplier = speedMultiplier;
    }

    public MoveSpeedPlayerAction(Action.Properties properties, float speedMultiplier, int ... duration) {
        super(properties, duration);
        this.speedMultiplier = speedMultiplier;
    }

    @Override
    public void onEnd(LivingEntity user) {
        CombatUtil.removeTransientModifier(user, user.m_21051_(Attributes.f_22279_), CombatUtil.ACTION_SPEED_ID);
    }

    @Override
    public void onTick(LivingEntity user) {
        IActionTracker capA = ActionTracker.get((Entity)user);
        if (!capA.isStunned() && (this.isChargeable() ? capA.isCharging() : !capA.isInactive())) {
            CombatUtil.addTransientMultiplier(user, user.m_21051_(Attributes.f_22279_), this.speedMultiplier, CombatUtil.ACTION_SPEED_ID, "action_speed");
            if (user.f_19853_.m_5776_() && this.speedMultiplier < 0.0f && !user.m_20096_()) {
                Vec3 velocity = user.m_20184_();
                float modifier = Math.max(0.0f, 1.0f + this.speedMultiplier / 2.0f);
                user.m_20334_(velocity.f_82479_ * (double)modifier, velocity.f_82480_, velocity.f_82481_ * (double)modifier);
            }
        } else {
            CombatUtil.removeTransientModifier(user, user.m_21051_(Attributes.f_22279_), CombatUtil.ACTION_SPEED_ID);
        }
        CombatUtil.alignBodyRotWithHead(user, ActionTracker.get((Entity)user));
    }
}

