/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.LaunchProjectileAction;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SlingThrow
extends LaunchProjectileAction {
    public SlingThrow(Action.Properties properties, float speedMultiplier, float velocity, int ... duration) {
        super(properties, speedMultiplier, velocity, duration);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                tCalc.add(0.0f, 0.35f, 0.0f);
                rCalc.add(-240.0f, 0.0f, 0.0f, Easing.inSine);
                break;
            }
            case 1: {
                rCalc.setLooping(true);
                if (frame <= 10) {
                    rCalc.length = 10;
                } else if (frame <= 19) {
                    rCalc.offset = 10;
                    rCalc.length = 19;
                } else if (frame <= 27) {
                    rCalc.offset = 19;
                    rCalc.length = 27;
                } else {
                    rCalc.offset = 27;
                    rCalc.length = 34;
                }
                rCalc.add(-360.0f, 0.0f, 0.0f, Easing.none);
                tCalc.freeze();
                break;
            }
            case 2: {
                tCalc.extend(-0.375f, -0.125f, -0.125f, Easing.outCubic);
                rCalc.add(-240.0f, 30.0f, 0.0f, Easing.outCubic);
                break;
            }
            case 3: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 4: {
                tCalc.extend(dTranslation);
                rCalc.wrapRotation();
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        if (data.size() == 6) {
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            switch (state) {
                case 0: {
                    mCalc.extend(0.0f, 75.0f, 0.0f);
                    rightHand.rCalc.extend(-170.0f, -35.0f, -70.0f + pitch / 2.0f);
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    leftArm.rCalc.extend(pitch / 4.0f, 0.0f, 0.0f);
                    leftHand.rCalc.extend(-35.0f, 0.0f, -11.0f);
                    break;
                }
                case 1: {
                    mCalc.freeze();
                    rightHand.rCalc.length /= 2;
                    rightHand.rCalc.add(charge > 0.0f ? 0.0f : Mth.m_14031_((float)(((float)frame + rightHand.rCalc.partialTicks) * 1.1f)) * 2.5f, 0.0f, 0.0f, Easing.none);
                    rightArm.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    break;
                }
                case 2: {
                    mCalc.extend(2.0f, -45.0f, 0.0f, Easing.outQuart);
                    rightHand.rCalc.extend(-35.0f, -10.0f, -30.0f, Easing.outQuart);
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.extend(8.0f - Math.abs(pitch) * 0.25f, 0.0f, -15.0f, Easing.outQuart);
                    leftArm.rCalc.freeze();
                    break;
                }
                case 3: {
                    mCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    break;
                }
                case 4: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.toDefaultRotation();
                    rightArm.rCalc.extend(rightArm.dRotation);
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.extend(data.dRotation.m_122239_(), 0.0f, data.dRotation.m_122269_(), Easing.inSine);
                break;
            }
            case 1: {
                data.rCalc.setLooping(true);
                if (frame <= 10) {
                    data.rCalc.length = 10;
                } else if (frame <= 19) {
                    data.rCalc.offset = 10;
                    data.rCalc.length = 19;
                } else if (frame <= 27) {
                    data.rCalc.offset = 19;
                    data.rCalc.length = 27;
                } else {
                    data.rCalc.offset = 27;
                    data.rCalc.length = 34;
                }
                data.rCalc.add(0.0f, 0.0f, 360.0f, Easing.none);
                break;
            }
            case 2: {
                data.rCalc.add(-85.0f, 90.0f, 0.0f, Easing.outCubic);
                break;
            }
            case 3: {
                data.rCalc.freeze();
                break;
            }
            case 4: {
                data.rCalc.wrapRotation();
                data.rCalc.extend(data.dRotation);
                data.tCalc.add(0.0f, -0.375f, 0.0f);
            }
        }
    }
}

