/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.MoveSpeedPlayerAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class WrapAction
extends MoveSpeedPlayerAction {
    public WrapAction(Action.Properties properties, int ... duration) {
        super(properties, -0.6f, duration);
    }

    @Override
    public void onChargeRelease(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && this.getExtraSound() != null && ActionTracker.get((Entity)user).isFullyCharged()) {
            user.f_19853_.m_6269_(null, (Entity)user, this.getExtraSound().get(), SoundSource.PLAYERS, 1.0f, 0.96f + user.f_19853_.f_46441_.nextFloat() * 0.08f);
        }
    }

    @Override
    public void onStart(LivingEntity user) {
        if (!user.f_19853_.f_46443_ && this.getSound() != null) {
            user.f_19853_.m_6269_(null, (Entity)user, this.getSound().get(), SoundSource.PLAYERS, 1.0f, 0.96f + user.f_19853_.f_46441_.nextFloat() * 0.08f);
        }
    }

    @Override
    public boolean hasChargeZoom() {
        return false;
    }

    @Override
    public int getMaxCharge() {
        return super.getMaxCharge() * 3;
    }

    @Override
    public int getChargeTimeout() {
        return this.getMaxCharge();
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        switch (state) {
            case 0: {
                float chargeFrame = (float)(ActionTracker.get((Entity)user).getCharge() - 2) + ActionTracker.get((Entity)user).getChargePartial();
                float f = (charge > 0.0f ? chargeFrame : (float)(frame - 1) + tCalc.partialTicks) * 0.6f;
                tCalc.add(-0.1875f + Mth.m_14031_((float)f) * 0.12f, -Mth.m_14089_((float)f) * 0.12f, 0.0f);
                break;
            }
            case 1: {
                tCalc.extend(dTranslation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            AnimationData rightLeg = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData leftLeg = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    float chargeFrame = (float)(ActionTracker.get((Entity)user).getCharge() - 2) + ActionTracker.get((Entity)user).getChargePartial();
                    float f = (charge > 0.0f ? chargeFrame : (float)(frame - 1) + rightHand.rCalc.partialTicks) * 0.6f;
                    rightHand.rCalc.extend(-45.0f + Mth.m_14031_((float)f) * 12.0f, -45.0f - Mth.m_14089_((float)f) * 12.0f, 0.0f);
                    break;
                }
                case 1: {
                    rightArm.rCalc.extend(rightArm.dRotation);
                    rightHand.rCalc.extend(rightHand.dRotation);
                }
            }
        }
    }
}

