/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action.guard;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.action.guard.GuardAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.item.item.MeleeWeaponItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.ActionToServer;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.util.CombatUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class CounterGuardAction
extends GuardAction {
    public CounterGuardAction(int ... duration) {
        super(duration);
    }

    public CounterGuardAction(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public void onAttackInput(Player player) {
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (capA.getState() == 0 && !ActionsNF.isEmpty(this.getChain((LivingEntity)player).getId()) && MeleeWeaponItem.canExecuteAttack(player, false) && player.f_19797_ - PlayerData.get(player).getLastBlockTick() <= 8) {
            CombatUtil.removeTransientModifier((LivingEntity)player, player.m_21051_(Attributes.f_22279_), CombatUtil.BLOCK_SLOW_ID);
            CombatUtil.removeTransientModifier((LivingEntity)player, player.m_21051_((Attribute)AttributesNF.POISE.get()), CombatUtil.BLOCK_POISE_ID);
            capA.startAction(this.getChain((LivingEntity)player).getId());
            NetworkHandler.toServer(new ActionToServer(PlayerData.get(player).getActiveHand() == InteractionHand.MAIN_HAND, capA.getActionID()));
        }
    }

    @Override
    public List<Component> getTooltips(ItemStack stack, @Nullable Level level, TooltipFlag isAdvanced) {
        List<Component> tooltips = super.getTooltips(stack, level, isAdvanced);
        if (ClientEngine.get().isShiftHeld()) {
            tooltips.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("action.guard.riposte_1")));
            tooltips.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("action.guard.riposte_2")));
            List<Component> riposteTips = ((Action)((Object)this.chainsTo().get())).getTooltips(stack, level, isAdvanced);
            for (int i = 0; i < riposteTips.size(); ++i) {
                if (i == 0) {
                    tooltips.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("action.riposte")).m_130946_(": ").m_7220_(riposteTips.get(i)));
                    continue;
                }
                tooltips.add((Component)new TextComponent(" ").m_7220_(riposteTips.get(i)));
            }
        }
        return tooltips;
    }
}

