/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action.guard;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.player.PlayerAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.item.IGuardingItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.RenderUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class GuardAction
extends PlayerAction {
    public GuardAction(int ... duration) {
        super(duration);
    }

    public GuardAction(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    public abstract boolean blocksDamageSource(DamageTypeSource var1);

    public abstract float getGuardAngle();

    @Override
    public boolean hasChargeZoom() {
        return false;
    }

    @Override
    public int getChargeTimeout() {
        return 32768;
    }

    @Override
    public int getRequiredCharge(LivingEntity user) {
        return !this.isChargeable() ? 0 : this.getDuration(this.getChargeState(), user);
    }

    @Override
    public void onEnd(LivingEntity user) {
        CombatUtil.removeTransientModifier(user, user.m_21051_(Attributes.f_22279_), CombatUtil.BLOCK_SLOW_ID);
        CombatUtil.removeTransientModifier(user, user.m_21051_((Attribute)AttributesNF.POISE.get()), CombatUtil.BLOCK_POISE_ID);
    }

    @Override
    public void onTick(LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (this.isActive(user)) {
                IPlayerData capP = PlayerData.get(player);
                CombatUtil.addTransientMultiplier(user, user.m_21051_(Attributes.f_22279_), user.f_19797_ - capP.getLastBlockTick() < 9 ? (double)-0.6f : (double)-0.2f, CombatUtil.BLOCK_SLOW_ID, "block_slow");
                CombatUtil.addTransientModifier(user, user.m_21051_((Attribute)AttributesNF.POISE.get()), 3.0, CombatUtil.BLOCK_POISE_ID, "block_poise", AttributeModifier.Operation.ADDITION);
                if (user.f_19853_.m_5776_() && !user.m_20096_()) {
                    Vec3 velocity = user.m_20184_();
                    float modifier = user.f_19797_ - capP.getLastBlockTick() < 9 ? 0.7f : 0.9f;
                    user.m_20334_(velocity.f_82479_ * (double)modifier, velocity.f_82480_, velocity.f_82481_ * (double)modifier);
                }
            } else {
                CombatUtil.removeTransientModifier(user, user.m_21051_(Attributes.f_22279_), CombatUtil.BLOCK_SLOW_ID);
                CombatUtil.removeTransientModifier(user, user.m_21051_((Attribute)AttributesNF.POISE.get()), CombatUtil.BLOCK_POISE_ID);
            }
        }
        CombatUtil.alignBodyRotWithHead(user, ActionTracker.get((Entity)user));
    }

    public float onAttackReceived(LivingEntity user, DamageTypeSource source, float damage, boolean playSound) {
        float newDamage = damage;
        if (this.isActive(user) && this.blocksDamageSource(source)) {
            float entityAngle;
            InteractionHand interactionHand;
            Entity attacker = source.m_7639_();
            if (user instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)user;
                IPlayerData capP = PlayerData.get((Player)player);
                if (capP.getStamina() <= 0.0) {
                    return newDamage;
                }
                capP.addStamina((float)(-source.getStunDuration()) * 2.0f);
            }
            Vec3 attackVec = source.hasHitCoords() ? new Vec3(source.getHitCoords().f_86214_ + attacker.m_20185_(), source.getHitCoords().f_86215_ + attacker.m_20186_(), source.getHitCoords().f_86216_ + attacker.m_20189_()) : attacker.m_146892_();
            float hitAngle = CombatUtil.getRelativeHorizontalAngle(user.m_146892_(), attackVec, user.m_6080_());
            float defense = 0.0f;
            if (user instanceof Player) {
                Player player = (Player)user;
                interactionHand = PlayerData.get(player).getActiveHand();
            } else {
                interactionHand = InteractionHand.MAIN_HAND;
            }
            InteractionHand hand = interactionHand;
            Item item = user.m_21120_(hand).m_41720_();
            if (item instanceof IGuardingItem) {
                IGuardingItem item2 = (IGuardingItem)item;
                defense = item2.getDefense(source);
            }
            boolean blocked = false;
            if (hitAngle >= -this.getGuardAngle() && hitAngle <= this.getGuardAngle()) {
                blocked = true;
            } else if (source.hasHitCoords() && Math.abs((entityAngle = CombatUtil.getRelativeHorizontalAngle(user.m_146892_(), attacker.m_146892_(), user.m_6080_())) - hitAngle) >= 180.0f) {
                blocked = true;
            }
            if (blocked) {
                newDamage = CombatUtil.applyDamageReduction(damage, defense);
                if (!user.f_19853_.f_46443_ && playSound) {
                    user.f_19853_.m_6269_(null, (Entity)user, this.getSound().get(), user.m_5720_(), 1.0f, (newDamage != 0.0f ? 0.8f : 1.0f) + user.f_19853_.f_46441_.nextFloat(-0.02f, 0.02f));
                }
            }
        }
        if (newDamage == 0.0f && user instanceof Player) {
            Player player = (Player)user;
            this.updateBlockTick(player);
        }
        return newDamage;
    }

    @Override
    public float onAttackReceived(LivingEntity user, DamageTypeSource source, float damage) {
        return this.onAttackReceived(user, source, damage, true);
    }

    @Override
    public float onDamageReceived(LivingEntity user, DamageTypeSource source, float damage) {
        float newDamage = this.onAttackReceived(user, source, damage, false);
        if (newDamage != damage) {
            if (user instanceof Player) {
                Player player = (Player)user;
                this.updateBlockTick(player);
            }
            return newDamage;
        }
        return damage;
    }

    @Override
    public boolean canStart(LivingEntity user) {
        return super.canStart(user) && PlayerData.get((Player)user).getStamina() > 0.0;
    }

    @Override
    public boolean canContinueCharging(LivingEntity user) {
        IPlayerData capP = PlayerData.get((Player)user);
        return capP.getStamina() > 0.0 || user.f_19797_ - capP.getLastBlockTick() <= 8;
    }

    @Override
    public List<Component> getTooltips(ItemStack stack, @Nullable Level level, TooltipFlag isAdvanced) {
        DamageType[] damageTypeArray;
        ObjectArrayList tooltips = new ObjectArrayList();
        tooltips.add(new TranslatableComponent("action.guard").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)));
        DecimalFormat format = new DecimalFormat("0");
        if (ClientEngine.get().isShiftHeld() && (damageTypeArray = stack.m_41720_()) instanceof IGuardingItem) {
            IGuardingItem item = (IGuardingItem)damageTypeArray;
            for (DamageType type : DamageType.STANDARD_TYPES) {
                float defense = item.getDefense(new DamageTypeSource(type.toString(), type));
                tooltips.add(new TextComponent(" ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)new TranslatableComponent("action.guard.block", new Object[]{format.format(defense * 100.0f) + "%", RenderUtil.getDamageTypeText(type)})));
            }
        }
        return tooltips;
    }

    public boolean isActive(LivingEntity user) {
        IActionTracker capA = ActionTracker.get((Entity)user);
        return capA.getState() == 0 && !capA.isInactive() && !capA.isStunned();
    }

    protected void updateBlockTick(Player player) {
        PlayerData.get(player).setLastBlockTick(player.f_19797_);
        NetworkHandler.toAllTrackingAndSelf((Entity)player, new GenericEntityToClient(NetworkHandler.Type.BLOCK_CLIENT, player.m_142049_()));
    }
}

