/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action.guard;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.player.action.guard.CounterGuardAction;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class WeaponGuardAction
extends CounterGuardAction {
    public WeaponGuardAction(int ... duration) {
        super(duration);
    }

    public WeaponGuardAction(Action.Properties properties, int ... duration) {
        super(properties, duration);
    }

    @Override
    public boolean blocksDamageSource(DamageTypeSource source) {
        return !source.isDoT() && source.hasEntity() && !source.m_19360_();
    }

    @Override
    public float getGuardAngle() {
        return 65.0f;
    }

    @Override
    public void transformOppositeHandFP(AnimationCalculator tCalc, int xSide, int side, IActionTracker capA) {
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        if (state == 0) {
            Player player = (Player)user;
            float block = AnimationUtil.getBlockRecoilProgress(player, tCalc.partialTicks);
            rCalc.addWithCharge(10.0f + 20.0f * block, 55.0f, -50.0f, charge, Easing.outQuart);
            tCalc.addWithCharge(-0.21875f, 0.03125f - block / 16.0f, 0.0625f + 3.0f * block / 16.0f, charge, Easing.outQuart);
        } else {
            rCalc.extend(dRotation);
            tCalc.extend(dTranslation);
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            if (state == 0) {
                float block = AnimationUtil.getBlockRecoilProgress((Player)user, mCalc.partialTicks);
                Vector3f vec = rightArm.dRotation.m_122281_();
                vec.m_122261_(0.3f);
                vec.m_122272_(pitch / 3.0f, 0.0f, 0.0f);
                rightArm.rCalc.extend(vec);
                rightHand.rCalc.addWithCharge(-70.0f - 5.0f * block, -45.0f + -15.0f * block, 35.0f - 5.0f * block, charge);
                Vector3f vec0 = leftArm.dRotation.m_122281_();
                vec0.m_122261_(0.65f);
                vec0.m_122272_(8.0f * block, 0.0f, -8.0f);
                leftArm.rCalc.extend(vec0);
            } else {
                rightArm.toDefaultRotation();
                rightHand.toDefaultRotation();
                leftArm.toDefaultRotation();
            }
        }
    }
}

