/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action.thrown;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.player.action.thrown.ThrowTechnique;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ThrowAxeTechnique
extends ThrowTechnique {
    public ThrowAxeTechnique(DamageType[] damageType, int stunDuration, int[] duration, Action.Properties properties, float throwVelocity, float curve, boolean spinning, AttackEffect ... effects) {
        super(damageType, stunDuration, duration, properties, throwVelocity, curve, spinning, effects);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        AnimationCalculator sCalc = data.sCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        Vector3f dScale = data.dScale;
        switch (state) {
            case 0: {
                tCalc.extendWithCharge(-0.1875f, 0.6875f, 0.1875f, charge, Easing.outQuart);
                rCalc.extendWithCharge(80.0f, 100.0f, 0.0f, charge, Easing.outQuart);
                break;
            }
            case 1: {
                tCalc.extend(-0.375f, 0.375f, -0.25f, Easing.outQuart);
                rCalc.extend(-40.0f, 100.0f, -60.0f, Easing.outCubic);
                break;
            }
            case 2: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 3: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        if (data.size() == 6) {
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            switch (state) {
                case 0: {
                    mCalc.extendWithCharge(-2.0f, 30.0f, 0.0f, charge, Easing.outQuart);
                    rightHand.rCalc.extendWithCharge(-190.0f + pitch, -15.0f, -15.0f, charge, Easing.outQuart);
                    rightArm.rCalc.extendWithCharge(0.0f, 0.0f, 0.0f, charge, Easing.outQuart);
                    leftArm.rCalc.extendWithCharge(pitch / 4.0f, 0.0f, 0.0f, charge, Easing.outQuart);
                    leftHand.rCalc.extendWithCharge(-35.0f, 0.0f, -11.0f, charge, Easing.outQuart);
                    break;
                }
                case 1: {
                    mCalc.extend(2.0f, -22.0f, 0.0f, Easing.outQuart);
                    rightHand.rCalc.extend(-22.0f + pitch, -10.0f + (pitch > 0.0f ? pitch / 3.0f : 0.0f), 0.0f, Easing.outQuart);
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.extend(8.0f - Math.abs(pitch) * 0.25f, 0.0f, -15.0f, Easing.outQuart);
                    leftArm.rCalc.freeze();
                    break;
                }
                case 2: {
                    mCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    break;
                }
                case 3: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.toDefaultRotation();
                    rightArm.rCalc.extend(rightArm.dRotation);
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.extendWithCharge(data.dRotation, charge, Easing.outQuart);
                break;
            }
            case 1: {
                data.rCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.extend(data.dRotation);
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)user.m_5686_(partial), (float)-70.0f, (float)45.0f);
    }
}

