/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.action.thrown;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.PlayerAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.entity.projectile.ThrownWeaponEntity;
import frostnox.nightfall.util.math.BoundingSphere;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class ThrowTechnique
extends PlayerAttack {
    public final float throwVelocity;
    public final float curve;
    public final boolean spinning;

    public ThrowTechnique(DamageType[] damageType, int stunDuration, int[] duration, Action.Properties properties, float throwVelocity, float curve, boolean spinning, AttackEffect ... effects) {
        super(0.0f, damageType, new HurtSphere(new BoundingSphere[0]), 1, stunDuration, duration, properties, effects);
        this.throwVelocity = throwVelocity;
        this.curve = curve;
        this.spinning = spinning;
    }

    @Override
    public int getChargeTimeout() {
        return 32768;
    }

    @Override
    public void onTick(LivingEntity user) {
        IActionTracker capA = ActionTracker.get((Entity)user);
        Level level = user.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (capA.getState() == this.getChargeState() + 1 && capA.getFrame() == 2 && !capA.isStunned()) {
                InteractionHand interactionHand;
                if (user instanceof Player) {
                    Player player = (Player)user;
                    interactionHand = PlayerData.get(player).getActiveHand();
                } else {
                    interactionHand = InteractionHand.MAIN_HAND;
                }
                ItemStack item = user.m_21120_(interactionHand);
                if (item.m_41619_()) {
                    return;
                }
                ThrownWeaponEntity thrownWeapon = new ThrownWeaponEntity((Level)level2, user, item, capA.getActionID());
                thrownWeapon.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, Math.min((float)capA.getCharge() / (float)this.getDuration(this.getChargeState(), user) * this.throwVelocity, this.throwVelocity), 1.0f);
                if (user instanceof Player) {
                    Player player = (Player)user;
                    if (player.m_150110_().f_35937_) {
                        thrownWeapon.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        player.m_150109_().m_36057_(item);
                    }
                }
                level2.m_7967_((Entity)thrownWeapon);
                level2.m_6269_(null, (Entity)thrownWeapon, capA.getCharge() >= this.getMaxCharge() ? this.getExtraSound().get() : this.getSound().get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public List<Component> getTooltips(ItemStack stack, @Nullable Level level, TooltipFlag isAdvanced) {
        return List.of(new TranslatableComponent("action.throw").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), new TextComponent(" ").m_7220_(super.getTooltips(stack, level, isAdvanced).get(0)));
    }
}

