/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.attack;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.action.player.PlayerAttack;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DiagonalSwingLeft
extends PlayerAttack
implements IClientAction {
    public DiagonalSwingLeft(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public DiagonalSwingLeft(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    public DiagonalSwingLeft(DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(0.0f, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        AnimationCalculator sCalc = data.sCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        Vector3f dScale = data.dScale;
        switch (state) {
            case 0: {
                tCalc.extend(-0.90625f, 0.625f, 0.125f, Easing.inOutSine);
                rCalc.extend(60.0f, 80.0f, 0.0f, Easing.inOutSine);
                break;
            }
            case 1: {
                tCalc.extend(-0.125f, -0.5625f, -0.1875f, Easing.outQuart);
                rCalc.extend(-50.0f, 60.0f, -10.0f, Easing.outQuart);
                break;
            }
            case 2: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 3: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        if (data.size() == 6) {
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            switch (state) {
                case 0: {
                    mCalc.extend(0.0f, -45.0f, 0.0f);
                    rightHand.rCalc.extend(-130.0f + pitch, -11.0f, 45.0f);
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.add(10.0f, 0.0f, 0.0f);
                    break;
                }
                case 1: {
                    mCalc.extend(0.0f, 20.0f, 0.0f, Easing.outQuart);
                    rightHand.rCalc.extend(-20.0f + pitch, -5.0f, 25.0f, Easing.outQuart);
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.extend(-35.0f, 0.0f, -10.0f, Easing.outCubic);
                    leftArm.rCalc.freeze();
                    break;
                }
                case 2: {
                    mCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    break;
                }
                case 3: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.toDefaultRotation();
                    rightArm.rCalc.extend(rightArm.dRotation);
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.extend(data.dRotation.m_122239_(), data.dRotation.m_122260_() - 5.0f, data.dRotation.m_122269_());
                break;
            }
            case 1: {
                data.rCalc.add(-30.0f, 0.0f, 0.0f);
                data.rCalc.setEasing(Easing.outQuart);
                break;
            }
            case 2: {
                data.rCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.extend(data.dRotation);
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)user.m_5686_(partial), (float)-35.0f, (float)5.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public int getBlockHitFrame(int state, LivingEntity user) {
        return Math.max(1, super.getBlockHitFrame(state, user) - 2);
    }
}

