/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.attack;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.PlayerAttack;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.item.ImpactSoundType;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ShieldRiposte
extends PlayerAttack {
    public ShieldRiposte(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public ShieldRiposte(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    public ShieldRiposte(DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(0.0f, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public ImpactSoundType getImpactSoundType(LivingEntity user) {
        return ImpactSoundType.STRIKE;
    }

    @Override
    public void onTick(LivingEntity user) {
        Player player;
        IActionTracker capA;
        if (user instanceof Player && !(capA = ActionTracker.get((Entity)(player = (Player)user))).isStunned() && capA.getState() == 1 && capA.getFrame() == 1 && user.f_19853_.m_5776_()) {
            ClientEngine.get().lastDashTick = player.f_19797_;
            Vec3 velocity = user.m_20184_();
            float modifier = (player.m_20096_() ? 0.7f : 0.2f) * player.f_19853_.m_8055_(player.m_20097_()).m_60734_().m_49961_();
            Vec3 lookAngle = user.m_20154_();
            user.m_20334_(velocity.f_82479_ + lookAngle.f_82479_ * (double)modifier, velocity.f_82480_, velocity.f_82481_ + lookAngle.f_82481_ * (double)modifier);
        }
    }

    @Override
    public void transformOppositeHandFP(AnimationCalculator tCalc, int xSide, int side, IActionTracker capA) {
        if (this.getAction().getTotalStates() > 1) {
            if (capA.getState() == 0) {
                tCalc.add(0.95f * (float)xSide * (float)side, -0.95f * (float)side, 0.0f);
            } else {
                tCalc.setStaticVector(0.95f * (float)xSide * (float)side, -0.95f * (float)side, 0.0f);
            }
            if (capA.getState() == this.getAction().getTotalStates() - 1) {
                tCalc.add(-0.95f * (float)xSide * (float)side, 0.95f * (float)side, 0.0f);
            }
        }
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        AnimationCalculator sCalc = data.sCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        Vector3f dScale = data.dScale;
        switch (state) {
            case 0: {
                tCalc.extend(-0.625f, 0.5f, 0.0625f, Easing.inOutSine);
                data.toDefaultRotation();
                break;
            }
            case 1: {
                tCalc.add(0.125f, 0.0625f, -0.4375f, Easing.outQuart);
                rCalc.add(10.0f, -12.0f, 0.0f, Easing.outQuart);
                break;
            }
            case 2: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 3: {
                data.toDefault();
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        if (data.size() == 6) {
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            switch (state) {
                case 0: {
                    mCalc.extend(0.0f, -25.0f, 0.0f);
                    rightHand.rCalc.extend(-70.0f, -45.0f, 35.0f);
                    rightArm.rCalc.extend(pitch, 0.0f, 0.0f);
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    break;
                }
                case 1: {
                    mCalc.extend(5.0f, 15.0f, 0.0f, Easing.outQuart);
                    rightHand.rCalc.add(-12.0f, 40.0f, 0.0f, Easing.outQuart);
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    break;
                }
                case 2: {
                    mCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    break;
                }
                case 3: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.toDefaultRotation();
                    rightArm.rCalc.extend(rightArm.dRotation);
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.rCalc.extend(data.dRotation.m_122239_() + 70.0f, data.dRotation.m_122260_() + 45.0f, data.dRotation.m_122269_() - 35.0f);
                data.tCalc.extend(data.dTranslation.m_122239_(), data.dTranslation.m_122260_(), data.dTranslation.m_122269_() - 0.1875f);
                break;
            }
            case 1: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.freeze();
                data.tCalc.freeze();
                break;
            }
            case 3: {
                data.toDefault();
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)(user.m_5686_(partial) - 20.0f), (float)-110.0f, (float)30.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public int getBlockHitFrame(int state, LivingEntity user) {
        return Math.max(1, super.getBlockHitFrame(state, user) - 2);
    }
}

