/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.attack;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.action.player.PlayerAttack;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class StabCharged
extends PlayerAttack
implements IClientAction {
    public StabCharged(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public StabCharged(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    public StabCharged(DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(0.0f, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        AnimationCalculator sCalc = data.sCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        Vector3f dScale = data.dScale;
        switch (state) {
            case 0: {
                tCalc.extend(0.21875f, 0.9375f, -0.125f, Easing.inOutSine);
                rCalc.extend(-90.0f, 45.0f, 0.0f, Easing.inOutSine);
                break;
            }
            case 1: {
                tCalc.addWithCharge(-0.0625f, 0.0f, 0.5f, charge, Easing.inOutSine);
                rCalc.freeze();
                break;
            }
            case 2: {
                tCalc.extend(-0.5f, 0.5f, -0.4375f, Easing.outQuart);
                rCalc.extend(-110.0f, 45.0f, 15.0f, Easing.outQuart);
                break;
            }
            case 3: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 4: {
                tCalc.extend(dTranslation);
                rCalc.extend(dRotation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        if (data.size() == 6) {
            int side = AnimationUtil.getActiveSideModifier((Player)user);
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            AnimationData rightLeg = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData leftLeg = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    mCalc.extend(0.0f, 20.0f, 0.0f);
                    rightHand.rCalc.extend(-190.0f + pitch, -35.0f, -15.0f);
                    rightArm.rCalc.extend(0.0f, 0.0f, 0.0f);
                    leftArm.rCalc.extend(pitch / 4.0f, 0.0f, 0.0f);
                    leftHand.rCalc.extend(-45.0f, 0.0f, -10.0f);
                    break;
                }
                case 1: {
                    mCalc.addWithCharge(0.0f, 15.0f, 0.0f, charge);
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    break;
                }
                case 2: {
                    mCalc.extend(0.0f, -45.0f, 0.0f);
                    mCalc.setEasing(Easing.outQuart);
                    rightArm.rCalc.freeze();
                    rightHand.rCalc.extend(-95.0f + pitch, 30.0f, -pitch / 8.0f, Easing.outQuart);
                    leftHand.rCalc.extend(20.0f, 0.0f, -15.0f, Easing.outQuart);
                    leftArm.rCalc.extend(0.0f, 0.0f, 0.0f, Easing.outQuart);
                    break;
                }
                case 3: {
                    mCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    rightHand.rCalc.freeze();
                    break;
                }
                case 4: {
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    mCalc.setEasing(Easing.inOutSine);
                    rightArm.rCalc.extend(rightArm.dRotation);
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                    rightHand.rCalc.extend(rightHand.dRotation);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        switch (state) {
            case 0: {
                data.rCalc.extend(data.dRotation.m_122239_() - 180.0f, data.dRotation.m_122260_(), data.dRotation.m_122269_());
                break;
            }
            case 1: {
                data.rCalc.freeze();
                break;
            }
            case 2: {
                data.rCalc.add(90.0f, 0.0f, 0.0f, Easing.outQuart);
                break;
            }
            case 3: {
                data.rCalc.freeze();
                break;
            }
            case 4: {
                data.rCalc.extend(data.dRotation);
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)(user.m_5686_(partial) - (float)(user.m_6047_() ? 11 : 14)), (float)-65.0f, (float)65.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 2;
    }

    @Override
    public int getRequiredCharge(LivingEntity user) {
        return 0;
    }
}

