/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.attack;

import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.action.player.PlayerAttack;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SwingRight
extends PlayerAttack
implements IClientAction {
    public SwingRight(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
    }

    public SwingRight(float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    public SwingRight(DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(0.0f, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
    }

    @Override
    public void transformModelFP(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        super.transformModelFP(state, frame, duration, charge, user, data);
        AnimationCalculator tCalc = data.tCalc;
        AnimationCalculator rCalc = data.rCalc;
        AnimationCalculator sCalc = data.sCalc;
        Vector3f dTranslation = data.dTranslation;
        Vector3f dRotation = data.dRotation;
        Vector3f dScale = data.dScale;
        switch (state) {
            case 0: {
                tCalc.extend(0.625f, 0.25f, 0.0f);
                rCalc.extend(-69.0f, 175.0f, 60.0f);
                break;
            }
            case 1: {
                tCalc.extend(-1.25f, 0.25f, 0.0625f, Easing.outCubic);
                rCalc.add(0.0f, 0.0f, -90.0f, Easing.outQuart);
                break;
            }
            case 2: {
                tCalc.freeze();
                rCalc.freeze();
                break;
            }
            case 3: {
                rCalc.extend(dRotation);
                tCalc.extend(dTranslation);
            }
        }
    }

    @Override
    protected void transformModelSingle(int state, int frame, int duration, float charge, float pitch, LivingEntity user, EnumMap<EntityPart, AnimationData> data, AnimationCalculator mCalc) {
        int side = AnimationUtil.getActiveSideModifier((Player)user);
        if (data.size() == 6) {
            AnimationData rightHand = data.get((Object)EntityPart.getSidedHand(side));
            AnimationData rightArm = data.get((Object)EntityPart.getSidedArm(side));
            AnimationData leftArm = data.get((Object)EntityPart.getSidedArm(-side));
            AnimationData leftHand = data.get((Object)EntityPart.getSidedHand(-side));
            AnimationData rightLeg = data.get((Object)EntityPart.LEG_RIGHT);
            AnimationData leftLeg = data.get((Object)EntityPart.LEG_LEFT);
            switch (state) {
                case 0: {
                    mCalc.extend(0.0f, 20.0f, 0.0f);
                    rightHand.rCalc.extend(0.0f, 90.0f, 70.0f);
                    rightArm.rCalc.extend(pitch - 90.0f, 0.0f, -pitch);
                    leftArm.rCalc.extend(pitch / 4.0f, 0.0f, 0.0f);
                    leftHand.rCalc.extend(-35.0f, 0.0f, -10.0f);
                    break;
                }
                case 1: {
                    mCalc.extend(0.0f, -45.0f, 0.0f, Easing.outQuart);
                    rightHand.rCalc.extend(20.0f, 90.0f, 0.0f, Easing.outCubic);
                    rightArm.rCalc.add(0.0f, 0.0f, pitch, Easing.outCubic);
                    leftHand.rCalc.add(70.0f, 0.0f, -15.0f);
                    leftArm.rCalc.freeze();
                    break;
                }
                case 2: {
                    mCalc.freeze();
                    rightHand.rCalc.freeze();
                    rightArm.rCalc.freeze();
                    leftHand.rCalc.freeze();
                    leftArm.rCalc.freeze();
                    break;
                }
                case 3: {
                    int offset = duration / 2;
                    mCalc.extend(0.0f, 0.0f, 0.0f);
                    rightHand.rCalc.extend(rightHand.dRotation.m_122239_(), 90.0f, rightHand.dRotation.m_122269_());
                    rightHand.rCalc.length = offset;
                    rightHand.rCalc.setEasing(Easing.inSine);
                    rightArm.rCalc.extend(rightArm.dRotation);
                    leftArm.rCalc.extend(leftArm.dRotation);
                    leftHand.rCalc.extend(leftHand.dRotation);
                    if (frame <= offset) break;
                    rightHand.rCalc.extend(rightHand.dRotation);
                    rightHand.rCalc.length = duration;
                    rightHand.rCalc.offset = offset;
                    rightHand.rCalc.setEasing(Easing.outSine);
                }
            }
        }
    }

    @Override
    public void transformLayerSingle(int state, int frame, int duration, float charge, LivingEntity user, AnimationData data) {
        switch (state) {
            case 0: {
                data.toDefaultRotation();
                break;
            }
            case 1: {
                data.rCalc.length = duration / 2;
                data.rCalc.add(-90.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                data.rCalc.freeze();
                break;
            }
            case 3: {
                data.rCalc.extend(data.dRotation);
            }
        }
    }

    @Override
    public float getPitch(LivingEntity user, float partial) {
        return Mth.m_14036_((float)(user.m_5686_(partial) - (float)(user.m_6047_() ? 5 : 10)), (float)-50.0f, (float)50.0f);
    }

    @Override
    public boolean isStateDamaging(int state) {
        return state == 1;
    }

    @Override
    public int getDamageEndFrame(int state, LivingEntity user) {
        return this.getDuration(state, user) - 2;
    }

    @Override
    public int getBlockHitFrame(int state, LivingEntity user) {
        return Math.max(1, super.getBlockHitFrame(state, user) - 1);
    }
}

