/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.action.player.technique;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.attack.VerticalSwingCharged;
import frostnox.nightfall.block.block.anvil.AnvilAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.world.GridUseToServer;
import frostnox.nightfall.registry.EntriesNF;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class HammerTechnique
extends VerticalSwingCharged {
    private final AnvilAction type;
    private final AnvilAction chargedType;

    public HammerTechnique(AnvilAction type, AnvilAction chargedType, float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, effects);
        this.type = type;
        this.chargedType = chargedType;
    }

    public HammerTechnique(AnvilAction type, AnvilAction chargedType, float damage, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(damage, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
        this.type = type;
        this.chargedType = chargedType;
    }

    public HammerTechnique(AnvilAction type, AnvilAction chargedType, DamageType[] damageType, HurtSphere hurtSpheres, int maxTargets, int stunDuration, int[] duration, Action.Properties properties, AttackEffect ... effects) {
        super(0.0f, damageType, hurtSpheres, maxTargets, stunDuration, duration, properties, effects);
        this.type = type;
        this.chargedType = chargedType;
    }

    @Override
    public void onClientTick(Player player) {
        if (!player.f_19853_.m_5776_()) {
            return;
        }
        Vec3i lookingAt = ClientEngine.get().microHitResult;
        BlockPos pos = ClientEngine.get().microBlockEntityPos;
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (capA.getState() == 1 && !capA.isStunned() && capA.getFrame() == this.getBlockHitFrame(1, (LivingEntity)player) && lookingAt != null && pos != null) {
            AnvilAction type = capA.getCharge() > capA.getAction().getMaxCharge() / 2 ? this.chargedType : this.type;
            NetworkHandler.toServer(new GridUseToServer(type.ordinal(), lookingAt, pos));
            PlayerData.get(player).setHitStopFrame(capA.getFrame());
        }
    }

    @Override
    public List<Component> getTooltips(ItemStack stack, @Nullable Level level, TooltipFlag isAdvanced) {
        List<Component> tooltips = super.getTooltips(stack, level, isAdvanced);
        if (ClientEngine.get().isShiftHeld() && ClientEngine.get().getPlayer() != null && PlayerData.get(ClientEngine.get().getPlayer()).hasCompletedEntry(EntriesNF.SMITHING.getId())) {
            tooltips.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("anvil.action.context").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TranslatableComponent("anvil.action." + this.type.toString().toLowerCase(Locale.ROOT) + ".info").m_130940_(ChatFormatting.DARK_AQUA)));
            tooltips.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("anvil.action.context_charged").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TranslatableComponent("anvil.action." + this.chargedType.toString().toLowerCase(Locale.ROOT) + ".info").m_130940_(ChatFormatting.DARK_AQUA)));
        }
        return tooltips;
    }
}

