/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;

public interface ICustomPathfindable {
    public static final OctalDirection[] GAP_DIRECTIONS = new OctalDirection[]{OctalDirection.CENTER, OctalDirection.NORTH, OctalDirection.WEST, OctalDirection.SOUTH, OctalDirection.EAST};
    public static final List<AABB> NO_BOXES = List.of();
    public static final List<AABB> FULL_BOXES = Shapes.m_83144_().m_83299_();

    public NodeType getRawNodeType(NodeManager var1, BlockState var2, BlockGetter var3, BlockPos var4);

    public NodeType getFloorNodeType(NodeManager var1, BlockState var2, BlockGetter var3, BlockPos var4);

    public List<AABB> getTopFaceShape(BlockState var1);

    public List<AABB> getBottomFaceShape(BlockState var1);

    default public OctalDirection getDirection(BlockState state) {
        return OctalDirection.CENTER;
    }

    default public NodeType getTypeForThinSideClosedShape(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos, OctalDirection dir, float centerOffset) {
        float z;
        float y;
        float x = (float)pos.m_123341_() + 0.5f + (float)dir.xStepInt * centerOffset;
        if (nodeManager.collidesWith(nodeManager.getEntityBox(x, y = (float)pos.m_123342_(), z = (float)pos.m_123343_() + 0.5f + (float)dir.zStepInt * centerOffset, 1.0)) && nodeManager.collidesWith(nodeManager.getEntityBox(x = (float)pos.m_123341_() + 0.5f + dir.xStepHalf, y, z = (float)pos.m_123343_() + 0.5f + dir.zStepHalf, 1.0))) {
            nodeManager.getNode((BlockPos)pos).partial = true;
            return NodeType.CLOSED;
        }
        nodeManager.getNode(pos).setPartialPath(x, y, z);
        return this.hasAnyFloorAt(state, pos, level) ? NodeType.WALKABLE : NodeType.OPEN;
    }

    default public NodeType getTypeForSideClosedShape(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos, OctalDirection dir) {
        float z;
        float y = pos.m_123342_();
        float x = (float)pos.m_123341_() + 0.5f + dir.xStepHalf;
        if (nodeManager.collidesWith(nodeManager.getEntityBox(x, y, z = (float)pos.m_123343_() + 0.5f + dir.zStepHalf, 1.0))) {
            nodeManager.getNode((BlockPos)pos).partial = true;
            return NodeType.CLOSED;
        }
        nodeManager.getNode(pos).setPartialPath(x, y, z);
        return this.hasAnyFloorAt(state, pos, level) ? NodeType.WALKABLE : NodeType.OPEN;
    }

    default public NodeType getTypeForTopClosedShape(NodeManager nodeManager, BlockPos pos, float ySpace) {
        nodeManager.getNode((BlockPos)pos).partial = true;
        return nodeManager.getEntityHeight() <= ySpace ? NodeType.OPEN_OR_WALKABLE : NodeType.CLOSED;
    }

    default public NodeType getTypeForCenteredBottomShape(NodeManager nodeManager, BlockPos pos, float yOffset) {
        float z;
        float y;
        float x = (float)pos.m_123341_() + 0.5f;
        if (!nodeManager.collidesWith(nodeManager.getEntityBox(x, y = (float)pos.m_123342_() + yOffset, z = (float)pos.m_123343_() + 0.5f))) {
            nodeManager.getNode(pos).setPartialPath(x, y, z);
            return NodeType.WALKABLE;
        }
        nodeManager.getNode((BlockPos)pos).partial = true;
        return NodeType.CLOSED;
    }

    default public NodeType getTypeForBottomClosedShape(NodeManager nodeManager, BlockGetter level, BlockPos pos, float yOffset) {
        BlockPos.MutableBlockPos abovePos = pos.m_122032_();
        for (int i = 1; i < nodeManager.getScanHeight(); ++i) {
            abovePos.m_142448_(abovePos.m_123342_() + 1);
            if (abovePos.m_123342_() >= nodeManager.getMaxBuildHeight()) break;
            if (level.m_8055_((BlockPos)abovePos).m_60647_(level, (BlockPos)abovePos, nodeManager.pathType)) continue;
            nodeManager.getNode((BlockPos)pos).partial = true;
            return NodeType.CLOSED;
        }
        float y = (float)pos.m_123342_() + yOffset;
        for (OctalDirection gapDirection : GAP_DIRECTIONS) {
            float z;
            float x = (float)pos.m_123341_() + 0.5f + gapDirection.xStepHalf;
            if (nodeManager.collidesWith(nodeManager.getEntityBox(x, y, z = (float)pos.m_123343_() + 0.5f + gapDirection.zStepHalf))) continue;
            nodeManager.getNode(pos).setPartialPath(x, y, z);
            return NodeType.WALKABLE;
        }
        nodeManager.getNode((BlockPos)pos).partial = true;
        return NodeType.CLOSED;
    }

    default public boolean hasFloorAt(float x, float z, BlockPos pos, BlockGetter level) {
        BlockState belowState;
        Block block;
        if ((x %= 1.0f) < 0.0f) {
            x += 1.0f;
        }
        if ((z %= 1.0f) < 0.0f) {
            z += 1.0f;
        }
        if ((block = (belowState = level.m_8055_(pos.m_7495_())).m_60734_()) instanceof ICustomPathfindable) {
            ICustomPathfindable pathfindable = (ICustomPathfindable)block;
            List<AABB> bBoxes = pathfindable.getTopFaceShape(belowState);
            if (bBoxes.isEmpty()) {
                return false;
            }
            for (AABB bBox : bBoxes) {
                if (!((double)x >= bBox.f_82288_) || !((double)x <= bBox.f_82291_) || !((double)z >= bBox.f_82290_) || !((double)z <= bBox.f_82293_)) continue;
                return true;
            }
            return false;
        }
        return belowState.m_60767_().m_76334_();
    }

    default public boolean hasAnyFloorAt(BlockState state, BlockPos pos, BlockGetter level) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        Block block = belowState.m_60734_();
        if (block instanceof ICustomPathfindable) {
            ICustomPathfindable pathfindable = (ICustomPathfindable)block;
            List<AABB> bBoxes = pathfindable.getTopFaceShape(belowState);
            if (bBoxes.isEmpty()) {
                return false;
            }
            List<AABB> boxes = this.getBottomFaceShape(state);
            if (boxes.isEmpty()) {
                return true;
            }
            for (AABB box : boxes) {
                for (AABB bBox : bBoxes) {
                    if (bBox.f_82288_ >= box.f_82288_ && bBox.f_82291_ <= box.f_82291_ && bBox.f_82290_ >= box.f_82290_ && bBox.f_82293_ <= box.f_82293_) continue;
                    return true;
                }
            }
            return false;
        }
        return belowState.m_60767_().m_76334_();
    }
}

