/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.block.IBlock;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.fluid.MetalFluid;
import frostnox.nightfall.util.data.Vec2f;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public interface IMetal
extends IBlock {
    public int getTier();

    public int getWorkTier();

    public Color getColor();

    public Category getCategory();

    public TagKey<Item> getTag();

    public Map<IMetal, Vec2f> getBaseMetals();

    public List<Float> getBaseDefenses();

    default public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    default public float getMeltTemp() {
        return TieredHeat.fromTier(this.getWorkTier() + 1).getBaseTemp();
    }

    default public Item getMatchingItem(TagKey<Item> tag) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!item.m_204114_().m_203656_(tag) || !item.m_204114_().m_203656_(this.getTag())) continue;
            return item;
        }
        return Items.f_41852_;
    }

    default public boolean canCreateFromFluids(Collection<FluidStack> fluids, float temperature) {
        MetalFluid metalFluid;
        if (this.getBaseMetals().isEmpty() || fluids.size() < this.getBaseMetals().size()) {
            return false;
        }
        Object2IntArrayMap units = new Object2IntArrayMap(fluids.size());
        int total = 0;
        for (FluidStack fluid : fluids) {
            Fluid fluid2 = fluid.getFluid();
            if (fluid2 instanceof MetalFluid) {
                metalFluid = (MetalFluid)fluid2;
                if (metalFluid.metal == this) continue;
                if (temperature < metalFluid.metal.getMeltTemp() || !this.getBaseMetals().containsKey(metalFluid.metal)) {
                    return false;
                }
                units.put((Object)metalFluid.metal, fluid.getAmount());
                total += fluid.getAmount();
                continue;
            }
            return false;
        }
        if (units.size() != this.getBaseMetals().size()) {
            return false;
        }
        for (FluidStack fluid : fluids) {
            Vec2f range;
            float part;
            metalFluid = (MetalFluid)fluid.getFluid();
            if (metalFluid.metal == this || !((part = (float)units.getInt((Object)metalFluid.metal) / (float)total) < (range = this.getBaseMetals().get(metalFluid.metal)).x()) && !(part > range.y())) continue;
            return false;
        }
        return true;
    }

    public static class Entry
    extends ForgeRegistryEntry<Entry> {
        public final IMetal value;

        public Entry(IMetal value) {
            this.value = value;
        }
    }

    public static enum Category {
        HARD,
        MYSTIC,
        NOBLE;

    }
}

