/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import com.mojang.math.Vector3f;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public interface IMicroGrid {
    public boolean[][][] getGrid();

    public int getGridXSize();

    public int getGridYSize();

    public int getGridZSize();

    public Vector3f getWorldGridOffset();

    public float getRotationDegrees();

    public ResourceLocation getRecipeID();

    public void setRecipeID(ResourceLocation var1);

    public boolean canUseGrid(Action var1);

    public boolean isValidActionType(int var1);

    public boolean useGrid(int var1, Vec3i var2, Player var3, ItemStack var4);

    default public void clearGrid() {
        for (int x = 0; x < this.getGridXSize(); ++x) {
            for (int y = 0; y < this.getGridYSize(); ++y) {
                for (int z = 0; z < this.getGridZSize(); ++z) {
                    this.getGrid()[x][y][z] = false;
                }
            }
        }
    }

    default public boolean isGridEmpty() {
        for (int x = 0; x < this.getGridXSize(); ++x) {
            for (int y = 0; y < this.getGridYSize(); ++y) {
                for (int z = 0; z < this.getGridZSize(); ++z) {
                    if (!this.getGrid()[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    default public boolean gridHas(int x, int y, int z) {
        if (this.gridContainsLocation(x, y, z)) {
            return this.getGrid()[x][y][z];
        }
        return false;
    }

    default public boolean gridContainsLocation(int x, int y, int z) {
        return x >= 0 && x < this.getGridXSize() && y >= 0 && y < this.getGridYSize() && z >= 0 && z < this.getGridZSize();
    }

    default public boolean hasAdjacency(int x, int y, int z) {
        if (!this.gridContainsLocation(x, y, z)) {
            return false;
        }
        if (x + 1 < this.getGridXSize() && this.getGrid()[x + 1][y][z]) {
            return true;
        }
        if (x - 1 >= 0 && this.getGrid()[x - 1][y][z]) {
            return true;
        }
        if (y + 1 < this.getGridYSize() && this.getGrid()[x][y + 1][z]) {
            return true;
        }
        if (y - 1 >= 0 && this.getGrid()[x][y - 1][z]) {
            return true;
        }
        if (z + 1 < this.getGridZSize() && this.getGrid()[x][y][z + 1]) {
            return true;
        }
        return z - 1 >= 0 && this.getGrid()[x][y][z - 1];
    }

    default public boolean hasAdjacencyExcluding(int x, int y, int z, int xExclude, int yExclude, int zExclude) {
        boolean adj;
        if (!this.gridContainsLocation(x, y, z)) {
            return false;
        }
        if (this.gridContainsLocation(xExclude, yExclude, zExclude) && this.getGrid()[xExclude][yExclude][zExclude]) {
            this.getGrid()[xExclude][yExclude][zExclude] = false;
            adj = this.hasAdjacency(x, y, z);
            this.getGrid()[xExclude][yExclude][zExclude] = true;
        } else {
            adj = this.hasAdjacency(x, y, z);
        }
        return adj;
    }

    default public Vec3 getWorldPos(BlockPos blockPos, float offX, float offY, float offZ) {
        float rot = -this.getRotationDegrees();
        Vec2 rotOffset = new Vec2(-((float)this.getGridXSize()) / 32.0f - this.getWorldGridOffset().m_122239_(), -((float)this.getGridZSize()) / 32.0f - this.getWorldGridOffset().m_122269_());
        Vector3f gridOffset = this.getWorldGridOffset();
        gridOffset.m_122272_(offX, offY, offZ);
        Vector3f offset = MathUtil.rotatePointByYaw(gridOffset, rot, rotOffset);
        return new Vec3((double)((float)blockPos.m_123341_() + offset.m_122239_()), (double)((float)blockPos.m_123342_() + offset.m_122260_()), (double)((float)blockPos.m_123343_() + offset.m_122269_()));
    }

    public static String idFromPos(int x, int y, int z) {
        return String.format("%02d%02d%02d", x, y, z);
    }

    public static int packedPosFromId(String id) {
        return Integer.parseInt(id.substring(0, 2)) << 4 & Integer.parseInt(id.substring(2, 4)) << 2 & Integer.parseInt(id.substring(4, 6));
    }

    public static Vec3i posFromId(String id) {
        return new Vec3i(Integer.parseInt(id.substring(0, 2)), Integer.parseInt(id.substring(2, 4)), Integer.parseInt(id.substring(4, 6)));
    }

    public static void copyGridData(boolean[][][] from, boolean[][][] to) {
        int xSize = to.length;
        int ySize = to[0].length;
        int zSize = to[0][0].length;
        if (from.length != xSize || from[0].length != ySize || from[0][0].length != zSize) {
            Nightfall.LOGGER.warn("Failed to copy micro-grid data due to unequal dimensions.");
            return;
        }
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    to[x][y][z] = from[x][y][z];
                }
            }
        }
    }

    public static boolean[][][] copyGrid(boolean[][][] grid) {
        boolean[][][] gridCopy = new boolean[grid.length][grid[0].length][grid[0][0].length];
        for (int x = 0; x < grid.length; ++x) {
            for (int y = 0; y < grid[0].length; ++y) {
                for (int z = 0; z < grid[0][0].length; ++z) {
                    gridCopy[x][y][z] = grid[x][y][z];
                }
            }
        }
        return gridCopy;
    }

    public static void clearGrid(boolean[][][] grid) {
        for (int x = 0; x < grid.length; ++x) {
            for (int y = 0; y < grid[0].length; ++y) {
                for (int z = 0; z < grid[0][0].length; ++z) {
                    grid[x][y][z] = false;
                }
            }
        }
    }

    public static boolean isEmpty(boolean[][][] grid) {
        for (int x = 0; x < grid.length; ++x) {
            for (int y = 0; y < grid[0].length; ++y) {
                for (int z = 0; z < grid[0][0].length; ++z) {
                    if (!grid[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean equals(boolean[][][] grid1, boolean[][][] grid2) {
        int xSize = grid1.length;
        int ySize = grid1[0].length;
        int zSize = grid1[0][0].length;
        if (grid2.length != xSize || grid2[0].length != ySize || grid2[0][0].length != zSize) {
            return false;
        }
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    if (grid1[x][y][z] == grid2[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static int compare(boolean[][][] grid1, boolean[][][] grid2) {
        int z;
        int y;
        int x;
        int size1 = 0;
        int size2 = 0;
        for (x = 0; x < grid1.length; ++x) {
            for (y = 0; y < grid1[0].length; ++y) {
                for (z = 0; z < grid1[0][0].length; ++z) {
                    if (!grid1[x][y][z]) continue;
                    ++size1;
                }
            }
        }
        for (x = 0; x < grid2.length; ++x) {
            for (y = 0; y < grid2[0].length; ++y) {
                for (z = 0; z < grid2[0][0].length; ++z) {
                    if (!grid2[x][y][z]) continue;
                    ++size2;
                }
            }
        }
        return Integer.compare(size1, size2);
    }
}

