/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.fluid.WaterFluidNF;
import frostnox.nightfall.registry.forge.FluidsNF;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface IWaterloggedBlock
extends BucketPickup,
LiquidBlockContainer {
    public int getExcludedWaterLevel(BlockState var1);

    @Nullable
    default public BlockState addLiquidToPlacement(BlockState state, BlockPlaceContext context) {
        return this.addLiquidToPlacement(state, context.m_8083_(), (LevelAccessor)context.m_43725_());
    }

    @Nullable
    default public BlockState addLiquidToPlacement(BlockState state, BlockPos pos, LevelAccessor level) {
        if (state == null) {
            return null;
        }
        FluidState fluid = level.m_6425_(pos);
        Fluid type = fluid.m_76152_();
        if (!type.m_6212_((Fluid)FluidsNF.WATER.get())) {
            return state;
        }
        if (fluid.m_76152_().m_7444_(fluid)) {
            return (BlockState)((BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(7))).m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)WaterlogType.fromFluid(type)));
        }
        if (fluid.m_76186_() > this.getExcludedWaterLevel(state)) {
            if (fluid.m_76186_() > 0) {
                level.m_186469_(pos, type, type.m_6718_((LevelReader)level));
            }
            return (BlockState)((BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(fluid.m_76186_()))).m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)WaterlogType.fromFluid(type)));
        }
        return state;
    }

    default public BlockState addLiquidToPlacementNoUpdate(BlockState state, FluidState fluid) {
        Fluid type = fluid.m_76152_();
        if (!type.m_6212_((Fluid)FluidsNF.WATER.get())) {
            return state;
        }
        if (fluid.m_76152_().m_7444_(fluid)) {
            return (BlockState)((BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(7))).m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)WaterlogType.fromFluid(type)));
        }
        if (fluid.m_76186_() > this.getExcludedWaterLevel(state)) {
            return (BlockState)((BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(fluid.m_76186_()))).m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)WaterlogType.fromFluid(type)));
        }
        return state;
    }

    default public FluidState getLiquid(BlockState state) {
        int water = (Integer)state.m_61143_((Property)BlockStatePropertiesNF.WATER_LEVEL);
        if (water != 0) {
            WaterFluidNF type = ((WaterlogType)((Object)state.m_61143_(BlockStatePropertiesNF.WATERLOG_TYPE))).fluid.get();
            return water == 7 ? type.m_76068_(false) : type.m_75953_(water, water == 6);
        }
        return Fluids.f_76191_.m_76145_();
    }

    default public void tickLiquid(BlockState state, BlockPos pos, LevelAccessor level) {
        int waterLevel = (Integer)state.m_61143_((Property)BlockStatePropertiesNF.WATER_LEVEL);
        if (waterLevel != 0) {
            int excludedLevel = this.getExcludedWaterLevel(state);
            if (waterLevel <= excludedLevel) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(0)), 3);
            }
            FluidState fluidState = state.m_60819_();
            level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
        }
    }

    default public BlockState copyLiquid(BlockState oldState, BlockState newState) {
        return (BlockState)((BlockState)newState.m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)((WaterlogType)((Object)oldState.m_61143_(BlockStatePropertiesNF.WATERLOG_TYPE)))))).m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)((Integer)oldState.m_61143_((Property)BlockStatePropertiesNF.WATER_LEVEL)));
    }

    default public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return ((Integer)state.m_61143_((Property)BlockStatePropertiesNF.WATER_LEVEL) != 7 || state.m_61143_(BlockStatePropertiesNF.WATERLOG_TYPE) != WaterlogType.fromFluid(fluid)) && fluid.m_6212_((Fluid)FluidsNF.WATER.get()) && fluid.m_7430_(fluid.m_76145_()) > this.getExcludedWaterLevel(state);
    }

    default public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluid) {
        if (fluid.m_76152_().m_6212_((Fluid)FluidsNF.WATER.get()) && (fluid.m_76186_() > Math.max((Integer)state.m_61143_((Property)BlockStatePropertiesNF.WATER_LEVEL), this.getExcludedWaterLevel(state)) || fluid.m_76170_())) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(fluid.m_76170_() ? 7 : fluid.m_76186_()))).m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)WaterlogType.fromFluid(fluid.m_76152_()))), 3);
            if (!level.m_5776_()) {
                level.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    default public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)BlockStatePropertiesNF.WATER_LEVEL) == 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(0)), 3);
            if (!state.m_60710_((LevelReader)level, pos)) {
                level.m_46961_(pos, true);
            }
            return new ItemStack((ItemLike)((WaterlogType)((Object)state.m_61143_(BlockStatePropertiesNF.WATERLOG_TYPE))).fluid.get().m_6859_());
        }
        return ItemStack.f_41583_;
    }

    default public Optional<SoundEvent> getPickupSound(BlockState state) {
        return ((WaterlogType)((Object)state.m_61143_(BlockStatePropertiesNF.WATERLOG_TYPE))).fluid.get().m_142520_();
    }

    @Deprecated
    default public Optional<SoundEvent> m_142298_() {
        return ((WaterFluidNF)((Object)FluidsNF.WATER.get())).m_142520_();
    }

    public static enum WaterlogType implements StringRepresentable
    {
        FRESH((Supplier<WaterFluidNF>)FluidsNF.WATER),
        SEA((Supplier<WaterFluidNF>)FluidsNF.SEAWATER);

        public final Supplier<WaterFluidNF> fluid;

        private WaterlogType(Supplier<WaterFluidNF> fluid) {
            this.fluid = fluid;
        }

        public static WaterlogType fromFluid(Fluid fluid) {
            if (fluid == FluidsNF.WATER.get() || fluid == FluidsNF.WATER_FLOWING.get()) {
                return FRESH;
            }
            return SEA;
        }

        public String m_7912_() {
            return this.toString().toLowerCase();
        }
    }
}

