/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.data.Vec2f;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MaterialColor;

public enum Metal implements IMetal
{
    TIN(0, 0, IMetal.Category.NOBLE, 5.0f, 5.0f, MaterialColor.f_76420_, new Color(-5392708), SoundType.f_154663_, Map.of()),
    COPPER(1, 1, IMetal.Category.HARD, 10.0f, 10.0f, MaterialColor.f_76413_, new Color(-3448262), SoundType.f_154663_, Map.of(), (List<Float>)FloatList.of((float[])new float[]{0.35f, 0.35f, 0.35f, 0.15f, 0.15f, -1.0f})),
    BRONZE(2, 1, IMetal.Category.HARD, 12.0f, 12.0f, MaterialColor.f_76373_, new Color(-4162243), SoundsNF.BRONZE_TYPE, Map.of(COPPER, new Vec2f(0.85f, 1.0f), TIN, new Vec2f(0.05f, 0.15f)), (List<Float>)FloatList.of((float[])new float[]{0.4f, 0.4f, 0.4f, 0.2f, 0.2f, 0.2f})),
    IRON(3, 3, IMetal.Category.HARD, 14.0f, 14.0f, MaterialColor.f_76419_, new Color(-11053740), SoundType.f_56725_, Map.of(), (List<Float>)FloatList.of((float[])new float[]{0.45f, 0.45f, 0.45f, 0.25f, 0.25f, 0.25f})),
    STEEL(4, 3, IMetal.Category.HARD, 18.0f, 18.0f, MaterialColor.f_76404_, new Color(-8946555), SoundType.f_56725_, Map.of(), (List<Float>)FloatList.of((float[])new float[]{0.5f, 0.5f, 0.5f, 0.3f, 0.3f, 0.3f})),
    METEORITE(1, 2, IMetal.Category.MYSTIC, 10.0f, 10.0f, MaterialColor.f_76422_, new Color(-8892003), SoundsNF.METEORITE_TYPE, Map.of(), (List<Float>)FloatList.of((float[])new float[]{0.25f, 0.25f, 0.25f, 0.35f, 0.35f, 0.35f}));

    private final int tier;
    private final int workTier;
    private final IMetal.Category category;
    private final float strength;
    private final float explosionResistance;
    private final MaterialColor materialColor;
    private final Color color;
    private final SoundType sound;
    private final Map<IMetal, Vec2f> bases;
    private final List<Float> defenses;
    private final TagKey<Item> itemTag;

    private Metal(int tier, int workTier, IMetal.Category category, float strength, float explosionResistance, MaterialColor materialColor, Color color, SoundType sound, Map<IMetal, Vec2f> bases) {
        this(tier, workTier, category, strength, explosionResistance, materialColor, color, sound, bases, (List<Float>)FloatList.of((float[])new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}));
    }

    private Metal(int tier, int workTier, IMetal.Category category, float strength, float explosionResistance, MaterialColor materialColor, Color color, SoundType sound, Map<IMetal, Vec2f> bases, List<Float> defenses) {
        this.tier = tier;
        this.workTier = workTier;
        this.category = category;
        this.strength = strength;
        this.explosionResistance = explosionResistance;
        this.materialColor = materialColor;
        this.color = color;
        this.sound = sound;
        this.bases = bases;
        this.defenses = defenses;
        this.itemTag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("metal/" + this.getName())));
    }

    @Nullable
    public static IMetal fromString(String searchString) {
        for (IMetal.Entry metal : RegistriesNF.getMetals()) {
            if (!searchString.contains(metal.value.getName())) continue;
            return metal.value;
        }
        return null;
    }

    @Override
    public MaterialColor getBaseColor() {
        return this.materialColor;
    }

    @Override
    public SoundType getSound() {
        return this.sound;
    }

    @Override
    public float getStrength() {
        return this.strength;
    }

    @Override
    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getWorkTier() {
        return this.workTier;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public IMetal.Category getCategory() {
        return this.category;
    }

    @Override
    public TagKey<Item> getTag() {
        return this.itemTag;
    }

    @Override
    public Map<IMetal, Vec2f> getBaseMetals() {
        return this.bases;
    }

    @Override
    public List<Float> getBaseDefenses() {
        return this.defenses;
    }
}

