/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.block.Fertility;
import frostnox.nightfall.block.ISoil;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;

public enum Soil implements ISoil
{
    SILT(0.85f, MaterialColor.f_76408_, SoundType.f_56739_, (Supplier<SoundEvent>)SoundsNF.DIRT_FALL, Fertility.POOR),
    DIRT(0.9f, MaterialColor.f_76370_, SoundType.f_56739_, (Supplier<SoundEvent>)SoundsNF.DIRT_FALL, Fertility.FAIR),
    LOAM(0.95f, MaterialColor.f_76384_, SoundType.f_56739_, (Supplier<SoundEvent>)SoundsNF.DIRT_FALL, Fertility.RICH),
    ASH(0.6f, MaterialColor.f_76420_, SoundType.f_56746_, () -> null, Fertility.NONE),
    GRAVEL(1.0f, MaterialColor.f_76409_, SoundType.f_56739_, (Supplier<SoundEvent>)SoundsNF.GRAVEL_FALL, Fertility.GRAVEL),
    BLUE_GRAVEL(1.0f, MaterialColor.f_76375_, SoundType.f_56739_, (Supplier<SoundEvent>)SoundsNF.GRAVEL_FALL, Fertility.GRAVEL),
    BLACK_GRAVEL(1.0f, MaterialColor.f_76365_, SoundType.f_56739_, (Supplier<SoundEvent>)SoundsNF.GRAVEL_FALL, Fertility.GRAVEL),
    SAND(0.8f, MaterialColor.f_76400_, SoundType.f_56746_, (Supplier<SoundEvent>)SoundsNF.SAND_FALL, Fertility.SAND),
    RED_SAND(0.8f, MaterialColor.f_76413_, SoundType.f_56746_, (Supplier<SoundEvent>)SoundsNF.SAND_FALL, Fertility.SAND),
    WHITE_SAND(0.8f, MaterialColor.f_76406_, SoundType.f_56746_, (Supplier<SoundEvent>)SoundsNF.SAND_FALL, Fertility.SAND);

    private final float strength;
    private final float explosionResistance;
    private final MaterialColor color;
    private final SoundType sound;
    private final Supplier<SoundEvent> slideSound;
    private final Fertility fertility;

    private Soil(float strength, MaterialColor color, SoundType sound, Supplier<SoundEvent> slideSound, Fertility fertility) {
        this(strength, 0.0f, color, sound, slideSound, fertility);
    }

    private Soil(float strength, float explosionResistance, MaterialColor color, SoundType sound, Supplier<SoundEvent> slideSound, Fertility fertility) {
        this.strength = strength;
        this.explosionResistance = explosionResistance;
        this.color = color;
        this.sound = sound;
        this.slideSound = slideSound;
        this.fertility = fertility;
    }

    @Override
    public MaterialColor getBaseColor() {
        return this.color;
    }

    @Override
    public SoundType getSound() {
        return this.sound;
    }

    @Override
    public float getStrength() {
        return this.strength;
    }

    @Override
    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    @Override
    public Supplier<SoundEvent> getSlideSound() {
        return this.slideSound;
    }

    @Override
    public Fertility getFertility() {
        return this.fertility;
    }

    public static RegistryObject<? extends Block> getBlock(Soil type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SILT -> BlocksNF.SILT;
            case DIRT -> BlocksNF.DIRT;
            case LOAM -> BlocksNF.LOAM;
            case ASH -> BlocksNF.ASH;
            case GRAVEL -> BlocksNF.GRAVEL;
            case BLUE_GRAVEL -> BlocksNF.BLUE_GRAVEL;
            case BLACK_GRAVEL -> BlocksNF.BLACK_GRAVEL;
            case SAND -> BlocksNF.SAND;
            case RED_SAND -> BlocksNF.RED_SAND;
            case WHITE_SAND -> BlocksNF.WHITE_SAND;
        };
    }
}

