/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.registry.forge.BiomesNF;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MaterialColor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SoilCover {
    GRASS("grassy", MaterialColor.f_76399_, SoundType.f_56740_){

        @Override
        public boolean canGrow(int aboveLight) {
            return aboveLight > 5;
        }
    }
    ,
    MOSS("mossy", MaterialColor.f_76363_, SoundType.f_56740_){

        @Override
        public boolean canGrow(int aboveLight) {
            return aboveLight < 14 && aboveLight > 0;
        }
    }
    ,
    FOREST("forested", MaterialColor.f_76370_, SoundType.f_154672_){

        @Override
        public boolean canGrow(int aboveLight) {
            return aboveLight > 0;
        }
    }
    ,
    LICHEN("lichenous", MaterialColor.f_76386_, SoundType.f_56739_){

        @Override
        public boolean canGrow(int aboveLight) {
            return aboveLight > 0;
        }
    };

    public final String prefix;
    public final MaterialColor color;
    public final SoundType sound;

    private SoilCover(String prefix, MaterialColor color, SoundType sound) {
        this.prefix = prefix;
        this.color = color;
        this.sound = sound;
    }

    public abstract boolean canGrow(int var1);

    @Nullable
    public static SoilCover getForBiome(Holder<Biome> biome) {
        if (biome.m_203565_(BiomesNF.TUNDRA.getKey())) {
            return LICHEN;
        }
        if (biome.m_203565_(BiomesNF.OLDWOODS.getKey()) || biome.m_203565_(BiomesNF.FOREST.getKey()) || biome.m_203565_(BiomesNF.JUNGLE.getKey())) {
            return FOREST;
        }
        if (biome.m_203565_(BiomesNF.DESERT.getKey()) || biome.m_203565_(BiomesNF.BADLANDS.getKey())) {
            return null;
        }
        return GRASS;
    }
}

