/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.block.ISoil;
import frostnox.nightfall.block.IStone;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.StoneType;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MaterialColor;

public enum Stone implements IStone
{
    SHALE(4.0f, 5.0f, MaterialColor.f_76409_, SoundType.f_154659_, Soil.GRAVEL, StoneType.SEDIMENTARY),
    SLATE(4.75f, 5.0f, MaterialColor.f_76375_, SoundType.f_154679_, Soil.BLUE_GRAVEL, StoneType.METAMORPHIC),
    DEEPSLATE(5.5f, 15.0f, MaterialColor.f_76419_, SoundType.f_154677_, Soil.GRAVEL, StoneType.IGNEOUS),
    SANDSTONE(4.0f, 5.0f, MaterialColor.f_76400_, SoundType.f_56742_, Soil.SAND, StoneType.SEDIMENTARY),
    SUNSCHIST(5.0f, 5.0f, MaterialColor.f_76413_, SoundType.f_56742_, Soil.RED_SAND, StoneType.METAMORPHIC),
    GRANITE(6.0f, 15.0f, MaterialColor.f_76408_, SoundType.f_56718_, Soil.RED_SAND, StoneType.IGNEOUS),
    LIMESTONE(4.0f, 5.0f, MaterialColor.f_76372_, SoundType.f_154661_, Soil.SAND, StoneType.SEDIMENTARY),
    MARBLE(4.5f, 5.0f, MaterialColor.f_76406_, SoundType.f_56742_, Soil.WHITE_SAND, StoneType.METAMORPHIC),
    BASALT(5.0f, 15.0f, MaterialColor.f_76365_, SoundType.f_56718_, Soil.BLACK_GRAVEL, StoneType.IGNEOUS),
    NIXWACKE(4.5f, 5.0f, MaterialColor.f_76421_, SoundType.f_154660_, Soil.WHITE_SAND, StoneType.SEDIMENTARY),
    AURGROT(5.5f, 5.0f, MaterialColor.f_76375_, SoundType.f_154679_, Soil.BLUE_GRAVEL, StoneType.METAMORPHIC),
    STYGFEL(6.0f, 15.0f, MaterialColor.f_76383_, SoundType.f_154677_, Soil.BLACK_GRAVEL, StoneType.IGNEOUS),
    PUMICE(2.5f, 4.0f, MaterialColor.f_76380_, SoundType.f_154659_, Soil.ASH, StoneType.IGNEOUS),
    MOONSTONE(10.0f, 15.0f, MaterialColor.f_76393_, SoundType.f_56726_, null, StoneType.METAMORPHIC);

    private final float strength;
    private final float explosionResistance;
    private final MaterialColor color;
    private final SoundType sound;
    private final ISoil soil;
    private final StoneType stoneType;

    private Stone(float strength, float explosionResistance, MaterialColor color, SoundType sound, ISoil soil, StoneType stoneType) {
        this.strength = strength;
        this.explosionResistance = explosionResistance;
        this.color = color;
        this.sound = sound;
        this.soil = soil;
        this.stoneType = stoneType;
    }

    @Override
    public MaterialColor getBaseColor() {
        return this.color;
    }

    @Override
    public SoundType getSound() {
        return this.sound;
    }

    @Override
    public float getStrength() {
        return this.strength;
    }

    @Override
    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    @Override
    @Nullable
    public ISoil getSoil() {
        return this.soil;
    }

    @Override
    public StoneType getType() {
        return this.stoneType;
    }
}

