/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public enum TieredHeat {
    NONE(0.0f, null, null, Color.WHITE),
    RED(100.0f, ParticleTypesNF.FLAME_RED, ParticleTypesNF.SPARK_RED, new Color(1.0f, 0.378f, 0.312f)),
    ORANGE(1000.0f, ParticleTypesNF.FLAME_ORANGE, ParticleTypesNF.SPARK_ORANGE, new Color(1.0f, 0.595f, 0.359f)),
    YELLOW(1200.0f, ParticleTypesNF.FLAME_YELLOW, ParticleTypesNF.SPARK_YELLOW, new Color(1.0f, 0.792f, 0.48f)),
    WHITE(1400.0f, ParticleTypesNF.FLAME_WHITE, ParticleTypesNF.SPARK_WHITE, new Color(1.0f, 1.0f, 0.869f)),
    BLUE(1600.0f, ParticleTypesNF.FLAME_BLUE, ParticleTypesNF.SPARK_BLUE, new Color(0.788f, 0.983f, 1.0f));

    private final float temperature;
    @Nullable
    private final RegistryObject<SimpleParticleType> flameParticle;
    @Nullable
    private final RegistryObject<SimpleParticleType> sparkParticle;
    public final Color color;

    private TieredHeat(@Nullable float temperature, RegistryObject<SimpleParticleType> flameParticle, RegistryObject<SimpleParticleType> sparkParticle, Color color) {
        this.temperature = temperature;
        this.flameParticle = flameParticle;
        this.sparkParticle = sparkParticle;
        this.color = color;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    public int getTier() {
        return this.ordinal();
    }

    public float getBaseTemp() {
        return this.temperature;
    }

    @Nullable
    public RegistryObject<SimpleParticleType> getFlameParticle() {
        return this.flameParticle;
    }

    @Nullable
    public RegistryObject<SimpleParticleType> getSparkParticle() {
        return this.sparkParticle;
    }

    public static TieredHeat getMinimumHeat(ItemStack item) {
        if (item.m_204117_(TagsNF.SMELT_TIER_CUSTOM)) {
            if (item.m_204117_(TagsNF.SMELT_TIER_0)) {
                return NONE;
            }
            if (item.m_204117_(TagsNF.SMELT_TIER_2)) {
                return ORANGE;
            }
            if (item.m_204117_(TagsNF.SMELT_TIER_3)) {
                return YELLOW;
            }
            if (item.m_204117_(TagsNF.SMELT_TIER_4)) {
                return WHITE;
            }
            if (item.m_204117_(TagsNF.SMELT_TIER_5)) {
                return BLUE;
            }
        }
        return RED;
    }

    public static float getMinimumTemp(ItemStack item) {
        return TieredHeat.getMinimumHeat(item).getBaseTemp();
    }

    public static TieredHeat fromTemp(float temperature) {
        if (temperature < 100.0f) {
            return NONE;
        }
        if (temperature < 1000.0f) {
            return RED;
        }
        if (temperature < 1200.0f) {
            return ORANGE;
        }
        if (temperature < 1400.0f) {
            return YELLOW;
        }
        if (temperature < 1600.0f) {
            return WHITE;
        }
        return BLUE;
    }

    public static TieredHeat fromTier(int tier) {
        if (tier < 0) {
            return NONE;
        }
        if (tier > 5) {
            return BLUE;
        }
        return TieredHeat.values()[tier];
    }
}

