/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block;

import frostnox.nightfall.block.ITree;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.world.generation.TreePool;
import frostnox.nightfall.world.generation.tree.AcaciaTreeGenerator;
import frostnox.nightfall.world.generation.tree.BirchTreeGenerator;
import frostnox.nightfall.world.generation.tree.CaedtarTreeGenerator;
import frostnox.nightfall.world.generation.tree.IronwoodTreeGenerator;
import frostnox.nightfall.world.generation.tree.JungleTreeGenerator;
import frostnox.nightfall.world.generation.tree.LarchTreeGenerator;
import frostnox.nightfall.world.generation.tree.MapleTreeGenerator;
import frostnox.nightfall.world.generation.tree.OakTreeGenerator;
import frostnox.nightfall.world.generation.tree.PalmTreeGenerator;
import frostnox.nightfall.world.generation.tree.RedwoodTreeGenerator;
import frostnox.nightfall.world.generation.tree.SpruceTreeGenerator;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import frostnox.nightfall.world.generation.tree.WillowTreeGenerator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;

public enum Tree implements ITree
{
    ACACIA(1.6f, 0.7f, 0.2f, 0.5f, 1.0f, 0.0f, 0.35f, MaterialColor.f_76380_, MaterialColor.f_76413_, new AcaciaTreeGenerator(6, 3, 3, 1, 3, 0.4f, true), 240, true, "patterned", null),
    BIRCH(1.2f, 0.55f, 0.6f, 0.4f, 0.75f, 0.4f, 0.85f, MaterialColor.f_76412_, MaterialColor.f_76400_, new BirchTreeGenerator(5, 7, 1, 0, 2), 200, true, "simple", ParticleTypesNF.LEAF_BIRCH),
    CAEDTAR(1.8f, 0.6f, 0.85f, 0.2f, 1.0f, 0.7f, 1.0f, MaterialColor.f_76388_, MaterialColor.f_76378_, new CaedtarTreeGenerator(4, 4, 2, 3, 2), 500, true, "ornate", ParticleTypesNF.LEAF_CAEDTAR),
    IRONWOOD(2.4f, 0.5f, 0.4f, 0.1f, 1.0f, 0.1f, 1.0f, MaterialColor.f_76379_, MaterialColor.f_76384_, new IronwoodTreeGenerator(8, 9, 2, 3, 1), 600, false, "ornate", ParticleTypesNF.LEAF_IRONWOOD),
    JUNGLE(1.0f, 0.6f, 0.75f, 0.45f, 0.65f, 0.6f, 1.0f, MaterialColor.f_76384_, MaterialColor.f_76408_, new JungleTreeGenerator(7, 10, 3, 4, 1, 0.7, false), 240, true, "rustic", ParticleTypesNF.LEAF_JUNGLE),
    LARCH(0.8f, 0.25f, 0.45f, 0.0f, 0.4f, 0.1f, 0.8f, MaterialColor.f_76379_, MaterialColor.f_76370_, new LarchTreeGenerator(7, 6, 2), 400, true, "medieval", null),
    MAPLE(1.4f, 0.5f, 0.6f, 0.3f, 0.7f, 0.2f, 1.0f, MaterialColor.f_76380_, MaterialColor.f_76408_, new MapleTreeGenerator(5, 6, 2, 2, 2), 280, true, "simple", ParticleTypesNF.LEAF_MAPLE),
    OAK(1.6f, 0.5f, 0.55f, 0.35f, 1.0f, 0.3f, 1.0f, MaterialColor.f_76384_, MaterialColor.f_76411_, new OakTreeGenerator(6, 5, 3, 3, 2), 340, true, "simple", ParticleTypesNF.LEAF_OAK),
    PALM(1.8f, 0.65f, 0.8f, 0.45f, 0.75f, 0.7f, 1.0f, MaterialColor.f_76380_, MaterialColor.f_76400_, new PalmTreeGenerator(7, 8, 0.6, true), 260, false, "patterned", null),
    REDWOOD(0.6f, 0.2f, 0.75f, 0.0f, 0.35f, 0.5f, 1.0f, MaterialColor.f_76373_, MaterialColor.f_76391_, new RedwoodTreeGenerator(10, 12, 1, 2, 1), 700, false, "medieval", null),
    SPRUCE(0.8f, 0.35f, 0.5f, 0.0f, 0.6f, 0.4f, 1.0f, MaterialColor.f_76362_, MaterialColor.f_76412_, new SpruceTreeGenerator(6, 6, 2), 360, false, "medieval", null),
    WILLOW(0.6f, 0.8f, 0.8f, 0.45f, 1.0f, 0.65f, 1.0f, MaterialColor.f_76384_, MaterialColor.f_76377_, new WillowTreeGenerator(7, 6, 2, 0, 2, 2, 4, 0.2f, true), 240, true, "rustic", ParticleTypesNF.LEAF_WILLOW);

    public static final Tree[] PRIMARY_TREES;
    public static final Tree[] SECONDARY_TREES;
    public static final Tree[] TERTIARY_TREES;
    public static final Tree[] QUATERNARY_TREES;
    public static final Tree[] LONE_TREES;
    public final float idealTemp;
    public final float idealHumidity;
    private final float strength;
    private final float explosionResistance;
    private final float minTemp;
    private final float maxTemp;
    private final float minHumidity;
    private final float maxHumidity;
    private final MaterialColor barkColor;
    private final MaterialColor woodColor;
    private final TreeGenerator treeGenerator;
    private final int growthInterval;
    private final boolean deciduous;
    private final String style;
    private final TagKey<Block> tag;
    @Nullable
    private final RegistryObject<ParticleType<BlockParticleOption>> particle;

    private Tree(float hardness, float idealTemp, float idealHumidity, float minTemp, float maxTemp, float minHumidity, float maxHumidity, MaterialColor barkColor, MaterialColor woodColor, TreeGenerator treeGenerator, int growthIntervalSeconds, @Nullable boolean deciduous, String style, RegistryObject<ParticleType<BlockParticleOption>> particle) {
        this(3.0f * hardness, 3.0f * hardness, idealTemp, idealHumidity, minTemp, maxTemp, minHumidity, maxHumidity, barkColor, woodColor, treeGenerator, growthIntervalSeconds, deciduous, style, particle);
    }

    private Tree(float strength, float explosionResistance, float idealTemp, float idealHumidity, float minTemp, float maxTemp, float minHumidity, float maxHumidity, MaterialColor barkColor, MaterialColor woodColor, TreeGenerator treeGenerator, int growthIntervalSeconds, @Nullable boolean deciduous, String style, RegistryObject<ParticleType<BlockParticleOption>> particle) {
        this.strength = strength;
        this.explosionResistance = explosionResistance;
        this.idealTemp = idealTemp;
        this.idealHumidity = idealHumidity;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.minHumidity = minHumidity;
        this.maxHumidity = maxHumidity;
        this.barkColor = barkColor;
        this.woodColor = woodColor;
        this.treeGenerator = treeGenerator;
        this.growthInterval = growthIntervalSeconds * 20;
        this.deciduous = deciduous;
        this.style = style;
        this.tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("tree/" + this.getName())));
        this.particle = particle;
    }

    @Nullable
    public static Tree pickRandomTree(TreePool pool, Random random) {
        if (pool.size() == 0) {
            return null;
        }
        int rand = random.nextInt(pool.totalWeight());
        int cumulativeWeight = 0;
        for (int i = 0; i < pool.size(); ++i) {
            TreePool.Entry entry = pool.trees()[i];
            if (rand >= (cumulativeWeight += entry.weight())) continue;
            return entry.tree();
        }
        return null;
    }

    @Nullable
    public static Tree chooseTree(Tree[] trees, float temp, float humidity) {
        Tree bestTree = null;
        float minDist = Float.MAX_VALUE;
        for (Tree tree : trees) {
            float humidityDist;
            float tempDist;
            float dist;
            if (!tree.canSurvive(temp, humidity) || !((dist = (tempDist = temp - tree.idealTemp) * tempDist + (humidityDist = humidity - tree.idealHumidity) * humidityDist) < minDist)) continue;
            minDist = dist;
            bestTree = tree;
        }
        return bestTree;
    }

    @Override
    public float getStrength() {
        return this.strength;
    }

    @Override
    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    @Override
    public MaterialColor getBarkColor() {
        return this.barkColor;
    }

    @Override
    public MaterialColor getBaseColor() {
        return this.woodColor;
    }

    @Override
    public SoundType getSound() {
        return SoundType.f_56736_;
    }

    @Override
    public TreeGenerator getGenerator() {
        return this.treeGenerator;
    }

    @Override
    public int getGrowthIntervalTicks() {
        return this.growthInterval;
    }

    @Override
    public boolean isDeciduous() {
        return this.deciduous;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public float getHardness() {
        return this.strength / 3.0f;
    }

    @Override
    public TagKey<Block> getTag() {
        return this.tag;
    }

    @Nullable
    public RegistryObject<ParticleType<BlockParticleOption>> getParticle() {
        return this.particle;
    }

    @Override
    public boolean canSurvive(float temperature, float humidity) {
        return temperature >= this.minTemp && temperature <= this.maxTemp && humidity >= this.minHumidity && humidity <= this.maxHumidity;
    }

    static {
        PRIMARY_TREES = new Tree[]{BIRCH, JUNGLE, LARCH};
        SECONDARY_TREES = new Tree[]{MAPLE, SPRUCE, WILLOW};
        TERTIARY_TREES = new Tree[]{ACACIA, CAEDTAR, OAK};
        QUATERNARY_TREES = new Tree[]{IRONWOOD, PALM, REDWOOD};
        LONE_TREES = new Tree[]{ACACIA, IRONWOOD, OAK, PALM, WILLOW};
    }
}

