/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.block.WaterloggedBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.SeatEntity;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChairBlock
extends WaterloggedBlock
implements ICustomPathfindable {
    public static final DirectionProperty FACING;
    public static final EnumProperty<Type> TYPE;
    public static final EnumProperty<DoubleBlockHalf> HALF;
    protected static final Map<Type, Map<Direction, VoxelShape>> BOTTOM_SHAPES;
    protected static final Map<Type, Map<Direction, VoxelShape>> TOP_SHAPES;
    protected static final Map<Type, Map<Direction, List<AABB>>> BOTTOM_FACES_BOTTOM;
    protected static final Map<Type, Map<Direction, List<AABB>>> BOTTOM_FACES_TOP;
    protected static final Map<Type, Map<Direction, List<AABB>>> TOP_FACES;

    public ChairBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)Type.SINGLE))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected Type getTypeAt(BlockState block, BlockGetter level, BlockPos pos) {
        Direction facing = (Direction)block.m_61143_((Property)FACING);
        boolean right = this.canConnect(block, level.m_8055_(pos.m_142300_(facing.m_122427_())));
        boolean left = this.canConnect(block, level.m_8055_(pos.m_142300_(facing.m_122428_())));
        if (right && left) {
            return Type.MIDDLE;
        }
        if (left) {
            return Type.RIGHT;
        }
        if (right) {
            return Type.LEFT;
        }
        return Type.SINGLE;
    }

    protected boolean canConnect(BlockState block, BlockState neighbor) {
        return neighbor.m_60713_((Block)this) && neighbor.m_61143_((Property)FACING) == block.m_61143_((Property)FACING);
    }

    protected boolean isConnected(BlockState block, BlockState neighbor, boolean left) {
        if (this.canConnect(block, neighbor)) {
            Type type = (Type)((Object)neighbor.m_61143_(TYPE));
            return type == Type.MIDDLE || (left ? type == Type.RIGHT : type == Type.LEFT);
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? BOTTOM_SHAPES.get(state.m_61143_(TYPE)).get(state.m_61143_((Property)FACING)) : TOP_SHAPES.get(state.m_61143_(TYPE)).get(state.m_61143_((Property)FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return level.m_8055_(pos.m_7495_()).m_60713_((Block)this);
        }
        return level.m_8055_(pos.m_7495_()).m_60659_((BlockGetter)level, pos.m_7495_(), Direction.UP, SupportType.RIGID);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player pPlayer) {
        if (!level.f_46443_ && pPlayer.m_7500_()) {
            LevelUtil.preventBlockLowerHalfDrop(level, pos, state, pPlayer);
        }
        super.m_5707_(level, pos, state, pPlayer);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            BlockState state = super.m_5573_(context);
            if (state == null) {
                return null;
            }
            Direction dir = context.m_8125_().m_122424_();
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)dir);
            if (!context.m_7078_()) {
                state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)this.getTypeAt(state, (BlockGetter)level, pos)));
            }
            return (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity pPlacer, ItemStack pStack) {
        state = (BlockState)((BlockState)state.m_61124_((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER);
        BlockPos abovePos = pos.m_7494_();
        level.m_7731_(abovePos, this.addLiquidToPlacement(state, abovePos, (LevelAccessor)level), 3);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)(state = super.m_7417_(state, facing, facingState, level, currentPos, facingPos)).m_61143_(HALF);
        if (half == DoubleBlockHalf.LOWER) {
            Type type;
            Type originalType = (Type)((Object)state.m_61143_(TYPE));
            Direction chairDir = (Direction)state.m_61143_((Property)FACING);
            Direction leftDir = chairDir.m_122427_();
            Direction rightDir = chairDir.m_122428_();
            if (leftDir == facing) {
                if (this.isConnected(state, facingState, true)) {
                    type = (Type)((Object)state.m_61143_(TYPE));
                    if (type == Type.SINGLE) {
                        state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT));
                    } else if (type != Type.LEFT) {
                        state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
                    }
                }
            } else if (rightDir == facing && this.isConnected(state, facingState, false)) {
                type = (Type)((Object)state.m_61143_(TYPE));
                if (type == Type.SINGLE) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT));
                } else if (type != Type.RIGHT) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
                }
            }
            if ((type = (Type)((Object)state.m_61143_(TYPE))) == Type.LEFT) {
                if (leftDir == facing && !this.isConnected(state, facingState, true)) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
                }
            } else if (type == Type.RIGHT) {
                if (rightDir == facing && !this.isConnected(state, facingState, false)) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
                }
            } else if (type == Type.MIDDLE) {
                if (leftDir == facing) {
                    if (!this.isConnected(state, facingState, true)) {
                        state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT));
                    }
                } else if (rightDir == facing && !this.isConnected(state, facingState, false)) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT));
                }
            }
            if (!(state.m_61143_(TYPE) == Type.MIDDLE || facing != Direction.DOWN && state.m_61143_(TYPE) == originalType || state.m_60710_((LevelReader)level, currentPos))) {
                state = Blocks.f_50016_.m_49966_();
            }
        }
        if (facing.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            state = facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != half ? (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING)))).m_61124_(TYPE, (Comparable)((Object)((Type)((Object)facingState.m_61143_(TYPE))))) : Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        List seats;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_20159_() && pos.m_203198_(pPlayer.m_20185_(), pPlayer.m_20186_() + (double)(pPlayer.m_20206_() / 2.0f), pPlayer.m_20189_()) <= 6.25 && (seats = level.m_45976_(SeatEntity.class, new AABB(pos))).isEmpty()) {
            SeatEntity seat = new SeatEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - pPlayer.m_6049_(), (double)pos.m_123343_() + 0.5, ((Direction)state.m_61143_((Property)FACING)).m_122435_());
            level.m_7967_((Entity)seat);
            pPlayer.m_20329_((Entity)seat);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this)) {
            List seats = level.m_45976_(SeatEntity.class, new AABB(pos));
            for (SeatEntity seat : seats) {
                seat.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{TYPE});
        builder.m_61104_(new Property[]{HALF});
    }

    public BlockState m_6843_(BlockState state, Rotation pRotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return state.m_60717_(pMirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        float z;
        float x;
        float edgeDist = 0.375f;
        boolean top = state.m_61143_(HALF) == DoubleBlockHalf.UPPER;
        float y = top ? (float)pos.m_123342_() + 0.375f : (float)pos.m_123342_() + 0.625f;
        OctalDirection travelDir = OctalDirection.fromDirection((Direction)state.m_61143_((Property)FACING));
        if (top) {
            travelDir = travelDir.getOpposite();
        }
        if (!nodeManager.collidesWith(nodeManager.getEntityBox(x = (float)pos.m_123341_() + 0.5f + travelDir.xStep * edgeDist, y, z = (float)pos.m_123343_() + 0.5f + travelDir.zStep * edgeDist))) {
            nodeManager.getNode(pos).setPartialPath(x, y, z);
            return NodeType.WALKABLE;
        }
        if (!top && !nodeManager.collidesWith(nodeManager.getEntityBox(x = (float)pos.m_123341_() + 0.5f + travelDir.xStep / 16.0f, y, z = (float)pos.m_123343_() + 0.5f + travelDir.zStep / 16.0f))) {
            nodeManager.getNode(pos).setPartialPath(x, y, z);
            return NodeType.WALKABLE;
        }
        nodeManager.getNode((BlockPos)pos).partial = true;
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? NodeType.OPEN : NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? TOP_FACES.get(state.m_61143_(TYPE)).get(state.m_61143_((Property)FACING)) : BOTTOM_FACES_TOP.get(state.m_61143_(TYPE)).get(state.m_61143_((Property)FACING));
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? TOP_FACES.get(state.m_61143_(TYPE)).get(state.m_61143_((Property)FACING)) : BOTTOM_FACES_BOTTOM.get(state.m_61143_(TYPE)).get(state.m_61143_((Property)FACING));
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    static {
        EnumMap<Direction, VoxelShape> map;
        VoxelShape shape;
        FACING = BlockStateProperties.f_61374_;
        TYPE = BlockStatePropertiesNF.CHAIR_TYPE;
        HALF = BlockStateProperties.f_61401_;
        BOTTOM_SHAPES = new EnumMap<Type, Map<Direction, VoxelShape>>(Type.class);
        BOTTOM_FACES_BOTTOM = new EnumMap<Type, Map<Direction, List<AABB>>>(Type.class);
        BOTTOM_FACES_TOP = new EnumMap<Type, Map<Direction, List<AABB>>>(Type.class);
        for (Type type : Type.values()) {
            Object dir2;
            shape = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Type.SINGLE -> Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)2.0, (double)10.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0)});
                case Type.LEFT -> Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0), Block.m_49796_((double)2.0, (double)10.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0)});
                case Type.RIGHT -> Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)0.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)0.0, (double)10.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0)});
                case Type.MIDDLE -> Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0));
            };
            map = new EnumMap<Direction, VoxelShape>(Direction.class);
            map.put(Direction.NORTH, shape);
            map.put(Direction.SOUTH, MathUtil.rotate(shape, Rotation.CLOCKWISE_180));
            map.put(Direction.WEST, MathUtil.rotate(shape, Rotation.COUNTERCLOCKWISE_90));
            map.put(Direction.EAST, MathUtil.rotate(shape, Rotation.CLOCKWISE_90));
            BOTTOM_SHAPES.put(type, map);
            EnumMap<Direction, List> bottomShapesMap = new EnumMap<Direction, List>(Direction.class);
            for (Object dir2 : Direction.Plane.HORIZONTAL) {
                bottomShapesMap.put((Direction)dir2, ((VoxelShape)map.get(dir2)).m_83263_(Direction.UP).m_83299_());
            }
            BOTTOM_FACES_BOTTOM.put(type, bottomShapesMap);
            EnumMap<Direction, List> topShapesMap = new EnumMap<Direction, List>(Direction.class);
            dir2 = Direction.Plane.HORIZONTAL.iterator();
            while (dir2.hasNext()) {
                Direction dir3 = (Direction)dir2.next();
                topShapesMap.put(dir3, ((VoxelShape)map.get(dir3)).m_83263_(Direction.DOWN).m_83299_());
            }
            BOTTOM_FACES_TOP.put(type, topShapesMap);
        }
        TOP_SHAPES = new EnumMap<Type, Map<Direction, VoxelShape>>(Type.class);
        TOP_FACES = new EnumMap<Type, Map<Direction, List<AABB>>>(Type.class);
        for (Type type : Type.values()) {
            shape = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Type.SINGLE -> Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)6.0, (double)14.0);
                case Type.LEFT -> Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0, (double)14.0);
                case Type.RIGHT -> Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)14.0, (double)6.0, (double)14.0);
                case Type.MIDDLE -> Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0, (double)14.0);
            };
            map = new EnumMap(Direction.class);
            map.put(Direction.NORTH, shape);
            map.put(Direction.SOUTH, MathUtil.rotate(shape, Rotation.CLOCKWISE_180));
            map.put(Direction.WEST, MathUtil.rotate(shape, Rotation.COUNTERCLOCKWISE_90));
            map.put(Direction.EAST, MathUtil.rotate(shape, Rotation.CLOCKWISE_90));
            TOP_SHAPES.put(type, map);
            EnumMap<Direction, List> shapesMap = new EnumMap<Direction, List>(Direction.class);
            for (Object dir2 : Direction.Plane.HORIZONTAL) {
                shapesMap.put((Direction)dir2, ((VoxelShape)map.get(dir2)).m_83263_(Direction.UP).m_83299_());
            }
            TOP_FACES.put(type, shapesMap);
        }
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE,
        LEFT,
        RIGHT,
        MIDDLE;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

