/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.INaturalVegetation;
import frostnox.nightfall.block.ISoil;
import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.block.block.SoilBlock;
import frostnox.nightfall.block.block.TilledSoilBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.ToolActionsNF;
import it.unimi.dsi.fastutil.ints.IntLongPair;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.RegistryObject;

public class CoveredSoilBlock
extends BlockNF
implements ITimeSimulatedBlock {
    public static final BooleanProperty SNOWY = BlockStateProperties.f_61451_;
    public final RegistryObject<? extends SoilBlock> soilBlock;
    public final RegistryObject<? extends TilledSoilBlock> tilledSoilBlock;
    public final ISoil soil;
    public final SoilCover soilCover;

    public CoveredSoilBlock(RegistryObject<? extends SoilBlock> soilBlock, RegistryObject<? extends TilledSoilBlock> tilledSoilBlock, ISoil soil, SoilCover soilCover, BlockBehaviour.Properties properties) {
        super(properties);
        this.soilBlock = soilBlock;
        this.tilledSoilBlock = tilledSoilBlock;
        this.soil = soil;
        this.soilCover = soilCover;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SNOWY, (Comparable)Boolean.FALSE));
    }

    private static boolean isSnowySetting(BlockState state) {
        return state.m_204336_(BlockTags.f_144279_);
    }

    private BlockState growVegetation(ServerLevel level, IChunkData chunkData, BlockPos pos, int skyLight) {
        ILevelData levelData = LevelData.get((Level)level);
        float temperature = chunkData.getTemperature(pos);
        float humidity = chunkData.getHumidity(pos);
        int density = 2;
        int range = Math.max(1, Math.round(5.0f - (humidity * 3.0f + 2.0f - Math.abs(temperature - 0.5f) * 2.0f) + levelData.getVegetationNoise(pos.m_123341_(), pos.m_123343_()) * 2.5f));
        int rangeSqr = range * range;
        int totalVegetation = 0;
        ObjectArraySet nearbyVegetation = new ObjectArraySet(density);
        block0: for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_142082_(-range, 0, -range), (BlockPos)pos.m_142082_(range, 0, range))) {
            ChunkAccess chunk;
            int zDist;
            int xDist = p.m_123341_() - pos.m_123341_();
            if (xDist * xDist + (zDist = p.m_123343_() - pos.m_123343_()) * zDist > rangeSqr || (chunk = level.m_6522_(SectionPos.m_123171_((int)p.m_123341_()), SectionPos.m_123171_((int)p.m_123343_()), ChunkStatus.f_62326_, false)) == null) continue;
            int i = 0;
            ObjectIterator searchPos = (BlockPos.MutableBlockPos)p;
            while (!level.m_151570_((BlockPos)searchPos) && Math.abs(i) <= range) {
                BlockState searchBlock = chunk.m_8055_((BlockPos)searchPos);
                if (searchBlock.m_60795_()) {
                    if (i > 0) continue block0;
                    --i;
                } else {
                    Block block = searchBlock.m_60734_();
                    if (block instanceof INaturalVegetation) {
                        INaturalVegetation vegetation = (INaturalVegetation)block;
                        nearbyVegetation.add((Object)vegetation);
                        if (++totalVegetation < density) continue block0;
                        return null;
                    }
                    if (i < 0) continue block0;
                    ++i;
                }
                searchPos.m_142448_(pos.m_123342_() + i);
            }
        }
        int totalWeight = 0;
        Object2IntArrayMap possibleVegetation = new Object2IntArrayMap();
        for (INaturalVegetation vegetation : RegistriesNF.getNaturalVegetation()) {
            if (!vegetation.canGrowAt(level, pos, this.soil, this.soilCover, skyLight, temperature, humidity)) continue;
            int weight = vegetation.getWeight();
            possibleVegetation.put((Object)vegetation, weight);
            totalWeight += weight;
        }
        int nearbyModifier = totalWeight * 4;
        for (INaturalVegetation vegetation : possibleVegetation.keySet()) {
            if (!nearbyVegetation.contains((Object)vegetation) || !vegetation.hasClusteredGrowth()) continue;
            possibleVegetation.put((Object)vegetation, possibleVegetation.getInt((Object)vegetation) + nearbyModifier);
            totalWeight += nearbyModifier;
        }
        if (totalWeight > 0) {
            Object vegetation = null;
            int weight = 0;
            int rand = level.f_46441_.nextInt(totalWeight);
            for (Object2IntMap.Entry entry : possibleVegetation.object2IntEntrySet()) {
                if (rand >= (weight += entry.getIntValue())) continue;
                vegetation = (INaturalVegetation)entry.getKey();
                break;
            }
            BlockState newBlock = vegetation.getGrowthBlock();
            level.m_7731_(pos, newBlock, 19);
            return newBlock;
        }
        return null;
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction == ToolActionsNF.TILL && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
            return ((TilledSoilBlock)this.tilledSoilBlock.get()).m_49966_();
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP ? (BlockState)state.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(CoveredSoilBlock.isSnowySetting(facingState))) : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        return (BlockState)this.m_49966_().m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(CoveredSoilBlock.isSnowySetting(blockstate)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{SNOWY});
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos abovePos = pos.m_7494_();
        int skyLight = level.m_45517_(LightLayer.SKY, abovePos);
        if (!this.soilCover.canGrow(skyLight)) {
            level.m_46597_(pos, ((SoilBlock)this.soilBlock.get()).m_49966_());
        } else if (level.m_8055_(abovePos).m_60795_() && random.nextInt(100) == 0 && Season.get((Level)level) != Season.WINTER) {
            this.growVegetation(level, ChunkData.get(level.m_46745_(abovePos)), abovePos, skyLight);
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ((SoilBlock)this.soilBlock.get()).m_49966_().getCloneItemStack(target, level, pos, player);
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        Block block;
        BlockState vegetation;
        long validTime;
        IntLongPair successesAndTrials;
        BlockPos abovePos = pos.m_7494_();
        int skyLight = level.m_45517_(LightLayer.SKY, abovePos);
        if (!this.soilCover.canGrow(skyLight)) {
            if (MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1) {
                level.m_46597_(pos, ((SoilBlock)this.soilBlock.get()).m_49966_());
            }
        } else if (level.m_8055_(abovePos).m_60795_() && (successesAndTrials = MathUtil.getRandomSuccessesAndRemainingTrials(randomTickChance / 100.0, validTime = Season.getTimePassedWithin(seasonTime, elapsedTime, 0L, 1008000L), 1, random)).firstInt() >= 1 && (vegetation = this.growVegetation(level, chunkData, abovePos, skyLight)) != null && (block = vegetation.m_60734_()) instanceof ITimeSimulatedBlock) {
            ITimeSimulatedBlock simulatable = (ITimeSimulatedBlock)block;
            simulatable.simulateTime(level, chunk, chunkData, abovePos, vegetation, successesAndTrials.secondLong(), gameTime, dayTime, seasonTime, seasonalTemp, randomTickChance, random);
        }
    }
}

