/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.util.LevelUtil;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CrossCollisionBlockNF
extends CrossCollisionBlock
implements IWaterloggedBlock,
ICustomPathfindable {
    public static final IntegerProperty WATER_LEVEL = BlockStatePropertiesNF.WATER_LEVEL;
    public static final EnumProperty<IWaterloggedBlock.WaterlogType> WATERLOG_TYPE = BlockStatePropertiesNF.WATERLOG_TYPE;
    protected final ObjectList<List<AABB>> yFaceByIndex;
    protected final VoxelShape[] blockEntityCollisionShapeByIndex;

    public CrossCollisionBlockNF(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight, BlockBehaviour.Properties properties) {
        super(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight, properties);
        ArrayList<List> temp = new ArrayList<List>(this.f_52315_.length);
        for (VoxelShape shape : this.f_52315_) {
            temp.add(shape.m_83263_(Direction.UP).m_83299_());
        }
        this.yFaceByIndex = new ObjectImmutableList(temp);
        this.blockEntityCollisionShapeByIndex = extensionHeight > 16.0f ? this.m_52326_(nodeWidth, extensionWidth, nodeHeight, extensionBottom, 16.0f) : this.f_52315_;
    }

    public abstract boolean connectsTo(BlockState var1, boolean var2, Direction var3);

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext entityContext;
        if (pContext instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)pContext).m_193113_() instanceof MovingBlockEntity) {
            return this.blockEntityCollisionShapeByIndex[this.m_52363_(pState)];
        }
        return this.f_52315_[this.m_52363_(pState)];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_52309_, f_52310_, f_52312_, f_52311_, WATER_LEVEL, WATERLOG_TYPE});
    }

    public FluidState m_5888_(BlockState state) {
        return this.getLiquid(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.tickLiquid(state, currentPos, level);
        return facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)state.m_61124_((Property)f_52314_.get(facing), (Comparable)Boolean.valueOf(this.connectsTo(facingState, facingState.m_60783_((BlockGetter)level, facingPos, facing.m_122424_()), facing.m_122424_()))) : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter pReader, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, pReader, pos, context);
    }

    public boolean m_7420_(BlockState state, BlockGetter pReader, BlockPos pos) {
        return (Integer)state.m_61143_((Property)WATER_LEVEL) == 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos northPos = pos.m_142127_();
        BlockPos eastPos = pos.m_142126_();
        BlockPos southPos = pos.m_142128_();
        BlockPos westPos = pos.m_142125_();
        BlockState northState = level.m_8055_(northPos);
        BlockState eastState = level.m_8055_(eastPos);
        BlockState southState = level.m_8055_(southPos);
        BlockState westState = level.m_8055_(westPos);
        return this.addLiquidToPlacement((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(this.connectsTo(northState, northState.m_60783_((BlockGetter)level, northPos, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(this.connectsTo(eastState, eastState.m_60783_((BlockGetter)level, eastPos, Direction.WEST), Direction.WEST)))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(this.connectsTo(southState, southState.m_60783_((BlockGetter)level, southPos, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(this.connectsTo(westState, westState.m_60783_((BlockGetter)level, westPos, Direction.EAST), Direction.EAST))), context);
    }

    @Override
    public int getExcludedWaterLevel(BlockState state) {
        return 0;
    }

    @Override
    public NodeType getRawNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        nodeManager.getNode((BlockPos)pos).partial = true;
        return NodeType.CLOSED;
    }

    @Override
    public NodeType getFloorNodeType(NodeManager nodeManager, BlockState state, BlockGetter level, BlockPos pos) {
        return NodeType.CLOSED;
    }

    @Override
    public List<AABB> getTopFaceShape(BlockState state) {
        return (List)this.yFaceByIndex.get(this.m_52363_(state));
    }

    @Override
    public List<AABB> getBottomFaceShape(BlockState state) {
        return (List)this.yFaceByIndex.get(this.m_52363_(state));
    }

    @Override
    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid pFluid) {
        return IWaterloggedBlock.super.m_6044_(level, pos, state, pFluid);
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState pFluidState) {
        return IWaterloggedBlock.super.m_7361_(level, pos, state, pFluidState);
    }

    @Override
    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return IWaterloggedBlock.super.m_142598_(level, pos, state);
    }

    @Override
    public Optional<SoundEvent> m_142298_() {
        return IWaterloggedBlock.super.m_142298_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LevelUtil.pickCloneItem(state.m_60734_(), player);
    }
}

