/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.SoilBlock;
import frostnox.nightfall.block.block.TilledSoilBlock;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.registries.RegistryObject;

public class DirtBlock
extends SoilBlock {
    public DirtBlock(Supplier<SoundEvent> slideSound, Map<SoilCover, RegistryObject<? extends CoveredSoilBlock>> map, RegistryObject<? extends TilledSoilBlock> tilledSoilBlock, BlockBehaviour.Properties properties) {
        super(slideSound, map, tilledSoilBlock, properties);
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        if (aboveState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            if (random.nextBoolean()) {
                level.m_46597_(pos, ((UnstableBlock)BlocksNF.MUD.get()).m_49966_());
            }
        } else {
            int light = level.m_45517_(LightLayer.SKY, abovePos);
            if (light > 0 && LevelUtil.isDay((LevelAccessor)level) && random.nextInt(10) == 0) {
                this.tryGrowCover(state, level, pos, abovePos, aboveState, light);
            }
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = chunk.m_8055_(abovePos);
        if (aboveState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            if (MathUtil.getRandomSuccesses(randomTickChance / 2.0, elapsedTime, 1, random) >= 1) {
                level.m_46597_(pos, ((UnstableBlock)BlocksNF.MUD.get()).m_49966_());
            }
        } else {
            int light = level.m_45517_(LightLayer.SKY, abovePos);
            if (light > 0 && MathUtil.getRandomSuccesses(randomTickChance / 10.0, LevelUtil.getDayTimePassed((Level)level, dayTime, elapsedTime), 1, random) >= 1) {
                this.tryGrowCover(state, level, pos, abovePos, aboveState, light);
            }
        }
    }
}

