/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.TimeDataBlockEntity;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.AxisDirection;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class DryingUnstableBlock
extends UnstableBlock
implements EntityBlock,
ITimeSimulatedBlock {
    public final Supplier<? extends Block> dryBlock;
    public final int ticksToDry;
    public final int minLightToDry;

    public DryingUnstableBlock(Supplier<? extends Block> dryBlock, int ticksToDry, int minLightToDry, Supplier<SoundEvent> slideSound, BlockBehaviour.Properties properties) {
        super(slideSound, properties);
        this.dryBlock = dryBlock;
        this.ticksToDry = ticksToDry;
        this.minLightToDry = minLightToDry;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TimeDataBlockEntity) {
            TimeDataBlockEntity entity = (TimeDataBlockEntity)blockEntity;
            BlockPos abovePos = pos.m_7494_();
            if (!level.m_46758_(abovePos)) {
                boolean canDry = false;
                BlockPos.MutableBlockPos neighborPos = pos.m_122032_();
                for (AxisDirection dir : AxisDirection.values()) {
                    if (level.m_6425_((BlockPos)neighborPos.m_122178_(pos.m_123341_() + dir.x, pos.m_123342_() + dir.y, pos.m_123343_() + dir.z)).m_205070_(FluidTags.f_13131_)) {
                        canDry = false;
                        break;
                    }
                    if (canDry || level.m_45524_((BlockPos)neighborPos, 0) < this.minLightToDry) continue;
                    canDry = true;
                }
                if (canDry) {
                    float humidity;
                    LevelChunk chunk = level.m_46745_(pos);
                    float f = humidity = ChunkData.isPresent(chunk) ? ChunkData.get(chunk).getHumidity(pos) : 0.5f;
                    if ((double)(level.m_46467_() - entity.lastProcessedTick) >= (double)this.ticksToDry * (0.5 + (double)humidity)) {
                        level.m_7731_(pos, this.dryBlock.get().m_49966_(), 3);
                    }
                } else {
                    entity.lastProcessedTick = level.m_46467_();
                }
            } else {
                entity.lastProcessedTick = level.m_46467_();
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.TIME_DATA.get()).m_155264_(pos, state);
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        if (MathUtil.getRandomSuccesses(randomTickChance, elapsedTime, 1, random) >= 1) {
            this.m_7455_(state, level, pos, random);
        }
    }
}

