/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import com.google.common.collect.ImmutableMap;
import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.registry.forge.BlocksNF;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FireBlockNF
extends BaseFireBlock
implements IHeatSource {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.m_137448_());
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public FireBlockNF(BlockBehaviour.Properties properties) {
        super(properties, 1.0f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().filter(state -> (Integer)state.m_61143_((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), FireBlockNF::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_53491_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_53491_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_53491_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? f_49237_ : voxelshape;
    }

    public static boolean canBePlacedAt(Level pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        if (!state.m_60795_()) {
            return false;
        }
        return ((FireBlockNF)BlocksNF.FIRE.get()).getPlacementState((BlockGetter)pLevel, pPos).m_60710_((LevelReader)pLevel, pPos);
    }

    public BlockState getPlacementState(BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (!this.canCatchFire(pLevel, pPos, Direction.UP) && !blockstate.m_60783_(pLevel, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(pLevel, pPos.m_142300_(direction), direction.m_122424_())));
            }
            return blockstate1;
        }
        return this.m_49966_();
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? this.getStateWithAge(pLevel, pCurrentPos, (Integer)pState.m_61143_((Property)AGE)) : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level pLevel = pContext.m_43725_();
        BlockPos pPos = pContext.m_8083_();
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (!this.canCatchFire((BlockGetter)pLevel, pPos, Direction.UP) && !blockstate.m_60783_((BlockGetter)pLevel, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire((BlockGetter)pLevel, pPos.m_142300_(direction), direction.m_122424_())));
            }
            return blockstate1;
        }
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        return pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, Direction.UP) || this.isValidFireLocation((BlockGetter)pLevel, pPos);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        level.m_186460_(pos, (Block)this, FireBlockNF.getFireTickDelay(level.f_46441_));
        if (level.m_46469_().m_46207_(GameRules.f_46131_)) {
            if (!state.m_60710_((LevelReader)level, pos)) {
                level.m_7471_(pos, false);
            }
            BlockState blockstate = level.m_8055_(pos.m_7495_());
            boolean flag = blockstate.isFireSource((LevelReader)level, pos, Direction.UP);
            int i = (Integer)state.m_61143_((Property)AGE);
            if (!flag && level.m_46471_() && this.isNearRain((Level)level, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
                level.m_7471_(pos, false);
            } else {
                int j = Math.min(15, i + rand.nextInt(3) / 2);
                if (i != j) {
                    state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j));
                    level.m_7731_(pos, state, 4);
                }
                if (!flag) {
                    if (!this.isValidFireLocation((BlockGetter)level, pos)) {
                        BlockPos blockpos = pos.m_7495_();
                        if (!level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, Direction.UP) || i > 3) {
                            level.m_7471_(pos, false);
                        }
                        return;
                    }
                    if (i == 15 && rand.nextInt(4) == 0 && !this.canCatchFire((BlockGetter)level, pos.m_7495_(), Direction.UP)) {
                        level.m_7471_(pos, false);
                        return;
                    }
                }
                this.spreadHeat((Level)level, pos, this.getHeat((Level)level, pos, state));
                boolean flag1 = level.m_46761_(pos);
                int k = flag1 ? -50 : 0;
                this.tryCatchFire((Level)level, pos.m_142126_(), 300 + k, rand, i, Direction.WEST);
                this.tryCatchFire((Level)level, pos.m_142125_(), 300 + k, rand, i, Direction.EAST);
                this.tryCatchFire((Level)level, pos.m_7495_(), 250 + k, rand, i, Direction.UP);
                this.tryCatchFire((Level)level, pos.m_7494_(), 250 + k, rand, i, Direction.DOWN);
                this.tryCatchFire((Level)level, pos.m_142127_(), 300 + k, rand, i, Direction.SOUTH);
                this.tryCatchFire((Level)level, pos.m_142128_(), 300 + k, rand, i, Direction.NORTH);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutableblockpos.m_122154_((Vec3i)pos, l, j1, i1);
                            int l1 = this.getFireOdds((LevelReader)level, (BlockPos)blockpos$mutableblockpos);
                            if (l1 <= 0) continue;
                            int i2 = (l1 + 60) / (i + 30);
                            if (flag1) {
                                i2 /= 2;
                            }
                            if (i2 <= 0 || rand.nextInt(k1) > i2 || level.m_46471_() && this.isNearRain((Level)level, (BlockPos)blockpos$mutableblockpos)) continue;
                            int j2 = Math.min(15, i + rand.nextInt(5) / 4);
                            level.m_7731_((BlockPos)blockpos$mutableblockpos, this.getStateWithAge((LevelAccessor)level, (BlockPos)blockpos$mutableblockpos, j2), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean isNearRain(Level pLevel, BlockPos pPos) {
        return pLevel.m_46758_(pPos) || pLevel.m_46758_(pPos.m_142125_()) || pLevel.m_46758_(pPos.m_142126_()) || pLevel.m_46758_(pPos.m_142127_()) || pLevel.m_46758_(pPos.m_142128_());
    }

    private void tryCatchFire(Level pLevel, BlockPos pPos, int pChance, Random pRandom, int pAge, Direction face) {
        int i = pLevel.m_8055_(pPos).getFlammability((BlockGetter)pLevel, pPos, face);
        if (pRandom.nextInt(pChance) < i) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            if (pRandom.nextInt(pAge + 10) < 5 && !pLevel.m_46758_(pPos)) {
                int j = Math.min(pAge + pRandom.nextInt(5) / 4, 15);
                pLevel.m_7731_(pPos, this.getStateWithAge((LevelAccessor)pLevel, pPos, j), 3);
            } else {
                pLevel.m_7471_(pPos, false);
            }
            blockstate.onCaughtFire(pLevel, pPos, face, null);
        }
    }

    private BlockState getStateWithAge(LevelAccessor pLevel, BlockPos pPos, int pAge) {
        BlockState blockstate;
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate11 = pLevel.m_8055_(blockpos);
        if (!this.canCatchFire((BlockGetter)pLevel, pPos, Direction.UP) && !blockstate11.m_60783_((BlockGetter)pLevel, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire((BlockGetter)pLevel, pPos.m_142300_(direction), direction.m_122424_())));
            }
            blockstate = blockstate1;
        } else {
            blockstate = this.m_49966_();
        }
        return blockstate.m_60713_((Block)BlocksNF.FIRE.get()) ? (BlockState)blockstate.m_61124_((Property)AGE, (Comparable)Integer.valueOf(pAge)) : blockstate;
    }

    private boolean isValidFireLocation(BlockGetter pLevel, BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(pLevel, pPos.m_142300_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private int getFireOdds(LevelReader pLevel, BlockPos pPos) {
        if (!pLevel.m_46859_(pPos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = pLevel.m_8055_(pPos.m_142300_(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((BlockGetter)pLevel, pPos.m_142300_(direction), direction.m_122424_()), i);
        }
        return i;
    }

    @Deprecated
    protected boolean m_7599_(BlockState pState) {
        return false;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        pLevel.m_186460_(pPos, (Block)this, FireBlockNF.getFireTickDelay(pLevel.f_46441_));
    }

    private static int getFireTickDelay(Random pRandom) {
        return 30 + pRandom.nextInt(10);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public boolean canCatchFire(BlockGetter world, BlockPos pos, Direction face) {
        return world.m_8055_(pos).isFlammable(world, pos, face);
    }

    public boolean isBurning(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    public TieredHeat getHeat(Level level, BlockPos pos, BlockState state) {
        return TieredHeat.RED;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean pIsMoving) {
        super.m_6810_(state, level, pos, newState, pIsMoving);
        if (!newState.m_60713_((Block)this)) {
            this.spreadHeat(level, pos, TieredHeat.NONE);
        }
    }
}

