/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.BlockNF;
import frostnox.nightfall.block.block.IceBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class FrazilBlock
extends BlockNF
implements ITimeSimulatedBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public final float meltTemp;

    public FrazilBlock(float meltTemp, BlockBehaviour.Properties properties) {
        super(properties);
        this.meltTemp = meltTemp;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (LevelData.isPresent((Level)level)) {
            BlockPos belowPos;
            ILevelData levelData = LevelData.get((Level)level);
            float temp = levelData.getSeasonalTemperature(ChunkData.get(level.m_46745_(belowPos = pos.m_7495_())), belowPos);
            if (temp > this.meltTemp) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            } else if (temp <= 0.2f) {
                Block water = level.m_8055_(belowPos).m_60734_();
                if (water == BlocksNF.WATER.get()) {
                    level.m_46597_(belowPos, ((IceBlock)BlocksNF.ICE.get()).m_49966_());
                } else if (water == BlocksNF.SEAWATER.get() && temp <= 0.05f) {
                    level.m_46597_(belowPos, ((IceBlock)BlocksNF.SEA_ICE.get()).m_49966_());
                }
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        FluidState fluid = level.m_6425_(pos.m_7495_());
        return fluid.m_76170_() && fluid.m_205070_(FluidTags.f_13131_);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 19);
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        IChunkData chunkData;
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level) && (chunkData = ChunkData.get(level.m_46745_(pos))).getTemperature(pos) >= this.meltTemp - 0.25f) {
            chunkData.addSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        IChunkData chunkData;
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level) && (chunkData = ChunkData.get(level.m_46745_(pos))).getTemperature(pos) >= this.meltTemp - 0.25f) {
            chunkData.removeSimulatableBlock(TickPriority.NORMAL, pos);
        }
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        float temperature = chunkData.getTemperature(pos);
        float seasonalFreezeTemp = this.meltTemp - temperature;
        LongLongPair freezeWindow = Season.getTimesAtTemperatureInfluence(seasonalFreezeTemp);
        if (seasonalTemp > seasonalFreezeTemp && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(seasonTime, elapsedTime % 1344001L, freezeWindow.secondLong(), seasonTime % 1344000L), 1, random) >= 1) {
            level.m_7471_(pos, false);
        } else {
            LongLongPair iceWindow;
            BlockPos belowPos = pos.m_7495_();
            Block water = level.m_8055_(belowPos).m_60734_();
            if (water == BlocksNF.WATER.get()) {
                LongLongPair iceWindow2 = Season.getTimesAtTemperatureInfluence(0.2f - temperature);
                if (MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(seasonTime, elapsedTime, iceWindow2.firstLong(), iceWindow2.secondLong()), 1, random) >= 1) {
                    level.m_7731_(belowPos, ((IceBlock)BlocksNF.ICE.get()).m_49966_(), 18);
                }
            } else if (water == BlocksNF.SEAWATER.get() && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(seasonTime, elapsedTime, (iceWindow = Season.getTimesAtTemperatureInfluence(0.05f - temperature)).firstLong(), iceWindow.secondLong()), 1, random) >= 1) {
                level.m_7731_(belowPos, ((IceBlock)BlocksNF.SEA_ICE.get()).m_49966_(), 18);
            }
        }
    }
}

